/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.lib;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import javax.mail.MessagingException;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.lib.Lock;
import org.apache.james.repository.api.Initializable;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMailRepository
implements MailRepository,
Configurable,
Initializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMailRepository.class);
    protected static final boolean DEEP_DEBUG = false;
    private final Lock lock = new Lock();

    public void configure(HierarchicalConfiguration configuration) throws ConfigurationException {
        this.doConfigure(configuration);
    }

    protected void doConfigure(HierarchicalConfiguration config) throws ConfigurationException {
    }

    public boolean unlock(MailKey key) {
        return this.lock.unlock(key);
    }

    public boolean lock(MailKey key) {
        return this.lock.lock(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailKey store(Mail mc) throws MessagingException {
        boolean wasLocked = true;
        MailKey key = MailKey.forMail((Mail)mc);
        try {
            AbstractMailRepository abstractMailRepository = this;
            synchronized (abstractMailRepository) {
                wasLocked = this.lock.isLocked(key);
                if (!wasLocked) {
                    this.lock(key);
                }
            }
            this.internalStore(mc);
            abstractMailRepository = key;
            return abstractMailRepository;
        }
        catch (MessagingException e) {
            LOGGER.error("Exception caught while storing mail {}", (Object)key, (Object)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Exception caught while storing mail {}", (Object)key, (Object)e);
            throw new MessagingException("Exception caught while storing mail " + key, e);
        }
        finally {
            if (!wasLocked) {
                this.unlock(key);
                AbstractMailRepository abstractMailRepository = this;
                synchronized (abstractMailRepository) {
                    this.notify();
                }
            }
        }
    }

    protected abstract void internalStore(Mail var1) throws MessagingException, IOException;

    public void remove(Mail mail) throws MessagingException {
        this.remove(MailKey.forMail((Mail)mail));
    }

    public void remove(Collection<Mail> mails) throws MessagingException {
        for (Mail mail : mails) {
            this.remove(mail);
        }
    }

    public void remove(MailKey key) throws MessagingException {
        if (this.lock(key)) {
            try {
                this.internalRemove(key);
            }
            finally {
                this.unlock(key);
            }
        } else {
            throw new MessagingException("Cannot lock " + key + " to remove it");
        }
    }

    protected abstract void internalRemove(MailKey var1) throws MessagingException;

    public long size() throws MessagingException {
        return Iterators.size((Iterator)this.list());
    }

    public void removeAll() throws MessagingException {
        ImmutableList.copyOf((Iterator)this.list()).forEach(Throwing.consumer(this::remove).sneakyThrow());
    }
}

