/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.adapter.mailbox;

import com.github.fge.lambdas.Throwing;
import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.adapter.mailbox.QuotaManagementMBean;
import org.apache.james.core.quota.QuotaCount;
import org.apache.james.core.quota.QuotaSize;
import org.apache.james.core.quota.QuotaValue;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.SerializableQuota;
import org.apache.james.mailbox.model.SerializableQuotaValue;
import org.apache.james.mailbox.quota.MaxQuotaManager;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.util.MDCBuilder;

public class QuotaManagement
implements QuotaManagementMBean {
    private final QuotaManager quotaManager;
    private final MaxQuotaManager maxQuotaManager;
    private final QuotaRootResolver quotaRootResolver;

    @Inject
    public QuotaManagement(QuotaManager quotaManager, MaxQuotaManager maxQuotaManager, QuotaRootResolver quotaRootResolver) {
        this.quotaManager = quotaManager;
        this.maxQuotaManager = maxQuotaManager;
        this.quotaRootResolver = quotaRootResolver;
    }

    @Override
    public String getQuotaRoot(String namespace, String user, String name) throws MailboxException {
        String string;
        block8: {
            Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)"CLI").addContext("action", (Object)"getQuotaRoot").build();
            try {
                string = this.quotaRootResolver.getQuotaRoot(new MailboxPath(namespace, user, name)).getValue();
                if (closeable == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (closeable != null) {
                        try {
                            closeable.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            closeable.close();
        }
        return string;
    }

    @Override
    public SerializableQuotaValue<QuotaCount> getMaxMessageCount(String quotaRoot) throws MailboxException {
        SerializableQuotaValue serializableQuotaValue;
        block8: {
            Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)"CLI").addContext("action", (Object)"getMaxMessageCount").build();
            try {
                serializableQuotaValue = SerializableQuotaValue.valueOf((Optional)this.maxQuotaManager.getMaxMessage(this.quotaRootResolver.fromString(quotaRoot)));
                if (closeable == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (closeable != null) {
                        try {
                            closeable.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            closeable.close();
        }
        return serializableQuotaValue;
    }

    @Override
    public SerializableQuotaValue<QuotaSize> getMaxStorage(String quotaRoot) throws MailboxException {
        SerializableQuotaValue serializableQuotaValue;
        block8: {
            Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)"CLI").addContext("action", (Object)"getMaxStorage").build();
            try {
                serializableQuotaValue = SerializableQuotaValue.valueOf((Optional)this.maxQuotaManager.getMaxStorage(this.quotaRootResolver.fromString(quotaRoot)));
                if (closeable == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (closeable != null) {
                        try {
                            closeable.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            closeable.close();
        }
        return serializableQuotaValue;
    }

    @Override
    public SerializableQuotaValue<QuotaCount> getGlobalMaxMessageCount() throws MailboxException {
        SerializableQuotaValue serializableQuotaValue;
        block8: {
            Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)"CLI").addContext("action", (Object)"getGlobalMaxMessageCount").build();
            try {
                serializableQuotaValue = SerializableQuotaValue.valueOf((Optional)this.maxQuotaManager.getGlobalMaxMessage());
                if (closeable == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (closeable != null) {
                        try {
                            closeable.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            closeable.close();
        }
        return serializableQuotaValue;
    }

    @Override
    public SerializableQuotaValue<QuotaSize> getGlobalMaxStorage() throws MailboxException {
        SerializableQuotaValue serializableQuotaValue;
        block8: {
            Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)"CLI").addContext("action", (Object)"getGlobalMaxStorage").build();
            try {
                serializableQuotaValue = SerializableQuotaValue.valueOf((Optional)this.maxQuotaManager.getGlobalMaxStorage());
                if (closeable == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (closeable != null) {
                        try {
                            closeable.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            closeable.close();
        }
        return serializableQuotaValue;
    }

    @Override
    public void setMaxMessageCount(String quotaRoot, SerializableQuotaValue<QuotaCount> maxMessageCount) {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)"CLI").addContext("action", (Object)"setMaxMessageCount").build();){
            maxMessageCount.toValue(QuotaCount::count, (QuotaValue)QuotaCount.unlimited()).ifPresent(Throwing.consumer(value -> this.maxQuotaManager.setMaxMessage(this.quotaRootResolver.fromString(quotaRoot), value)).sneakyThrow());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setMaxStorage(String quotaRoot, SerializableQuotaValue<QuotaSize> maxSize) {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)"CLI").addContext("action", (Object)"setMaxStorage").build();){
            maxSize.toValue(QuotaSize::size, (QuotaValue)QuotaSize.unlimited()).ifPresent(Throwing.consumer(value -> this.maxQuotaManager.setMaxStorage(this.quotaRootResolver.fromString(quotaRoot), value)).sneakyThrow());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setGlobalMaxMessageCount(SerializableQuotaValue<QuotaCount> maxGlobalMessageCount) {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)"CLI").addContext("action", (Object)"setGlobalMaxMessageCount").build();){
            maxGlobalMessageCount.toValue(QuotaCount::count, (QuotaValue)QuotaCount.unlimited()).ifPresent(Throwing.consumer(arg_0 -> ((MaxQuotaManager)this.maxQuotaManager).setGlobalMaxMessage(arg_0)).sneakyThrow());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setGlobalMaxStorage(SerializableQuotaValue<QuotaSize> maxGlobalSize) {
        try (Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)"CLI").addContext("action", (Object)"setGlobalMaxStorage").build();){
            maxGlobalSize.toValue(QuotaSize::size, (QuotaValue)QuotaSize.unlimited()).ifPresent(Throwing.consumer(arg_0 -> ((MaxQuotaManager)this.maxQuotaManager).setGlobalMaxStorage(arg_0)).sneakyThrow());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SerializableQuota<QuotaCount> getMessageCountQuota(String quotaRoot) throws MailboxException {
        SerializableQuota serializableQuota;
        block8: {
            Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)"CLI").addContext("action", (Object)"getMessageCountQuota").build();
            try {
                serializableQuota = SerializableQuota.newInstance((Quota)this.quotaManager.getMessageQuota(this.quotaRootResolver.fromString(quotaRoot)));
                if (closeable == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (closeable != null) {
                        try {
                            closeable.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            closeable.close();
        }
        return serializableQuota;
    }

    @Override
    public SerializableQuota<QuotaSize> getStorageQuota(String quotaRoot) throws MailboxException {
        SerializableQuota serializableQuota;
        block8: {
            Closeable closeable = MDCBuilder.create().addContext("protocol", (Object)"CLI").addContext("action", (Object)"getStorageQuota").build();
            try {
                serializableQuota = SerializableQuota.newInstance((Quota)this.quotaManager.getStorageQuota(this.quotaRootResolver.fromString(quotaRoot)));
                if (closeable == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (closeable != null) {
                        try {
                            closeable.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            closeable.close();
        }
        return serializableQuota;
    }
}

