/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.impl.camel;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.mail.MessagingException;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.mailetcontainer.impl.MatcherMailetPair;
import org.apache.james.mailetcontainer.impl.camel.CamelProcessor;
import org.apache.james.mailetcontainer.impl.camel.MatcherSplitter;
import org.apache.james.mailetcontainer.lib.AbstractStateMailetProcessor;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.mailet.Mail;
import org.apache.mailet.Mailet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelMailetProcessor
extends AbstractStateMailetProcessor
implements CamelContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(CamelMailetProcessor.class);
    private CamelContext context;
    private ProducerTemplate producerTemplate;
    private final MetricFactory metricFactory;
    private List<MatcherMailetPair> pairs;

    public CamelMailetProcessor(MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
    }

    public void service(Mail mail) throws MessagingException {
        try {
            this.producerTemplate.sendBody(this.getEndpoint(), (Object)mail);
        }
        catch (CamelExecutionException ex) {
            throw new MessagingException("Unable to process mail " + mail.getName(), (Exception)((Object)ex));
        }
    }

    public CamelContext getCamelContext() {
        return this.context;
    }

    public void setCamelContext(CamelContext context) {
        this.context = context;
    }

    public List<MatcherMailetPair> getPairs() {
        return ImmutableList.copyOf(this.pairs);
    }

    protected String getEndpoint() {
        return "direct:processor." + this.getState();
    }

    @Override
    @PostConstruct
    public void init() throws Exception {
        this.producerTemplate = this.context.createProducerTemplate();
        if (this.context.getStatus().isStopped()) {
            this.context.start();
        }
        super.init();
    }

    @Override
    protected void setupRouting(List<MatcherMailetPair> pairs) throws MessagingException {
        try {
            this.pairs = pairs;
            this.context.addRoutes((RoutesBuilder)new MailetContainerRouteBuilder(this, this.metricFactory, pairs));
        }
        catch (Exception e) {
            throw new MessagingException("Unable to setup routing for MailetMatcherPairs", e);
        }
    }

    private static class MailetContainerRouteBuilder
    extends RouteBuilder {
        private final CamelMailetProcessor container;
        private final List<MatcherMailetPair> pairs;
        private final MetricFactory metricFactory;

        private MailetContainerRouteBuilder(CamelMailetProcessor container, MetricFactory metricFactory, List<MatcherMailetPair> pairs) {
            this.container = container;
            this.metricFactory = metricFactory;
            this.pairs = pairs;
        }

        public void configure() {
            String state = this.container.getState();
            CamelProcessor terminatingMailetProcessor = new CamelProcessor(this.metricFactory, this.container, (Mailet)new AbstractStateMailetProcessor.TerminatingMailet());
            RouteDefinition processorDef = (RouteDefinition)this.from(this.container.getEndpoint()).routeId(state).setExchangePattern(ExchangePattern.InOnly);
            for (MatcherMailetPair pair : this.pairs) {
                CamelProcessor mailetProccessor = new CamelProcessor(this.metricFactory, this.container, pair.getMailet());
                MatcherSplitter matcherSplitter = new MatcherSplitter(this.metricFactory, this.container, pair);
                ((SplitDefinition)processorDef.split().method((Object)matcherSplitter)).aggregationStrategy((AggregationStrategy)new UseLatestAggregationStrategy()).process(exchange -> this.handleMailet(exchange, this.container, mailetProccessor));
            }
            processorDef.process(exchange -> this.terminateSmoothly(exchange, this.container, terminatingMailetProcessor));
        }

        private void terminateSmoothly(Exchange exchange, CamelMailetProcessor container, CamelProcessor terminatingMailetProcessor) throws Exception {
            Mail mail = (Mail)exchange.getIn().getBody(Mail.class);
            if (mail.getState().equals(container.getState())) {
                terminatingMailetProcessor.process(mail);
            }
            if (mail.getState().equals("ghost")) {
                this.dispose(exchange, mail);
            }
            this.complete(exchange, container);
        }

        private void handleMailet(Exchange exchange, CamelMailetProcessor container, CamelProcessor mailetProccessor) throws Exception {
            Mail mail = (Mail)exchange.getIn().getBody(Mail.class);
            boolean isMatched = mail.removeAttribute(MatcherSplitter.MATCHER_MATCHED_ATTRIBUTE).isPresent();
            if (isMatched) {
                mailetProccessor.process(mail);
            }
            if (mail.getState().equals("ghost")) {
                this.dispose(exchange, mail);
                return;
            }
            if (!mail.getState().equals(container.getState())) {
                container.toProcessor(mail);
                this.complete(exchange, container);
            }
        }

        private void complete(Exchange exchange, CamelMailetProcessor container) {
            LOGGER.debug("End of mailetprocessor for state {} reached", (Object)container.getState());
            exchange.setProperty("CamelRouteStop", (Object)true);
        }

        private void dispose(Exchange exchange, Mail mail) throws MessagingException {
            LifecycleUtil.dispose((Object)mail.getMessage());
            LifecycleUtil.dispose((Object)mail);
            exchange.setProperty("CamelRouteStop", (Object)true);
        }
    }
}

