/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.impl.jmx;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.james.core.MailAddress;
import org.apache.james.lifecycle.api.Disposable;
import org.apache.james.mailetcontainer.impl.jmx.MailetManagement;
import org.apache.james.mailetcontainer.impl.jmx.MatcherManagement;
import org.apache.james.mailetcontainer.impl.matchers.CompositeMatcher;
import org.apache.james.mailetcontainer.lib.AbstractStateMailetProcessor;
import org.apache.mailet.Mailet;
import org.apache.mailet.Matcher;

public class JMXStateMailetProcessorListener
implements AbstractStateMailetProcessor.MailetProcessorListener,
Disposable {
    private final AbstractStateMailetProcessor processor;
    private final MBeanServer mbeanserver;
    private final List<ObjectName> mbeans = new ArrayList<ObjectName>();
    private final Map<Mailet, MailetManagement> mailetMap = new HashMap<Mailet, MailetManagement>();
    private final Map<Matcher, MatcherManagement> matcherMap = new HashMap<Matcher, MatcherManagement>();
    private final String name;

    public JMXStateMailetProcessorListener(String name, AbstractStateMailetProcessor processor) throws JMException {
        this.processor = processor;
        this.name = name;
        this.mbeanserver = ManagementFactory.getPlatformMBeanServer();
        this.registerMBeans();
    }

    @Override
    public void afterMailet(Mailet m, String mailName, String state, long processTime, Exception e) {
        MailetManagement mgmt = this.mailetMap.get(m);
        if (mgmt != null) {
            mgmt.update(processTime, e == null);
        }
    }

    @Override
    public void afterMatcher(Matcher m, String mailName, Collection<MailAddress> rcpts, Collection<MailAddress> matches, long processTime, Exception e) {
        MatcherManagement mgmt = this.matcherMap.get(m);
        if (mgmt != null) {
            boolean matched = false;
            if (matches != null) {
                matched = !matches.isEmpty();
            }
            mgmt.update(processTime, e == null, matched);
        }
    }

    private void registerMBeans() throws JMException {
        String baseObjectName = "org.apache.james:type=component,component=mailetcontainer,name=processor,processor=" + this.name;
        this.registerMailets(baseObjectName, this.processor.getMailets().iterator());
        this.registerMatchers(baseObjectName, this.processor.getMatchers().iterator(), 0);
    }

    private void registerMailets(String parentMBeanName, Iterator<Mailet> mailets) throws JMException {
        int i = 0;
        while (mailets.hasNext()) {
            Mailet mailet = mailets.next();
            MailetManagement mailetManagement = new MailetManagement(mailet.getMailetConfig());
            String mailetMBeanName = parentMBeanName + ",subtype=mailet,index=" + i++ + ",mailetname=" + mailetManagement.getMailetName();
            this.registerMBean(mailetMBeanName, mailetManagement);
            this.mailetMap.put(mailet, mailetManagement);
        }
    }

    private void registerMatchers(String parentMBeanName, Iterator<Matcher> matchers, int nestingLevel) throws JMException {
        int i = 0;
        while (matchers.hasNext()) {
            Matcher matcher = matchers.next();
            MatcherManagement matcherManagement = new MatcherManagement(matcher.getMatcherConfig());
            String matcherMBeanName = parentMBeanName + ",subtype" + nestingLevel + "=matcher,index" + nestingLevel + "=" + i++ + ",matchername" + nestingLevel + "=" + matcherManagement.getMatcherName();
            this.registerMBean(matcherMBeanName, matcherManagement);
            this.matcherMap.put(matcher, matcherManagement);
            if (!(matcher instanceof CompositeMatcher)) continue;
            this.registerMatchers(matcherMBeanName, ((CompositeMatcher)matcher).getMatchers().iterator(), nestingLevel + 1);
        }
    }

    private void registerMBean(String mBeanName, Object object) throws JMException {
        ObjectName objectName = new ObjectName(mBeanName);
        this.mbeanserver.registerMBean(object, objectName);
        this.mbeans.add(objectName);
    }

    public void dispose() {
        this.unregisterMBeans();
        this.mailetMap.clear();
        this.matcherMap.clear();
    }

    private void unregisterMBeans() {
        ArrayList<ObjectName> unregistered = new ArrayList<ObjectName>();
        for (ObjectName name : this.mbeans) {
            try {
                this.mbeanserver.unregisterMBean(name);
                unregistered.add(name);
            }
            catch (JMException jMException) {}
        }
        this.mbeans.removeAll(unregistered);
    }
}

