/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.impl.matchers;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.mailetcontainer.impl.matchers.GenericCompositeMatcher;
import org.apache.mailet.Mail;
import org.apache.mailet.Matcher;

public class Xor
extends GenericCompositeMatcher {
    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        Collection<MailAddress> finalResult = null;
        boolean first = true;
        for (Matcher matcher : this.getMatchers()) {
            Collection<MailAddress> matchedAddresses = Optional.ofNullable(matcher.match(mail)).orElse(new ArrayList());
            if (first) {
                finalResult = matchedAddresses;
                first = false;
                continue;
            }
            finalResult = this.performXor(finalResult, matchedAddresses);
        }
        return finalResult;
    }

    private Collection<MailAddress> performXor(Collection<MailAddress> collection1, Collection<MailAddress> collection2) {
        ImmutableSet set1 = ImmutableSet.copyOf(collection1);
        ImmutableSet set2 = ImmutableSet.copyOf(collection2);
        return Sets.difference((Set)Sets.union((Set)set1, (Set)set2), (Set)Sets.intersection((Set)set1, (Set)set2)).immutableCopy();
    }
}

