/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.data;

import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.ProvidesIntoSet;
import java.util.List;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.dlp.api.DLPConfigurationStore;
import org.apache.james.dlp.eventsourcing.EventSourcingDLPConfigurationStore;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.lib.DomainListConfiguration;
import org.apache.james.domainlist.memory.MemoryDomainList;
import org.apache.james.mailrepository.api.MailRepositoryUrlStore;
import org.apache.james.mailrepository.api.Protocol;
import org.apache.james.mailrepository.memory.MailRepositoryStoreConfiguration;
import org.apache.james.mailrepository.memory.MemoryMailRepository;
import org.apache.james.mailrepository.memory.MemoryMailRepositoryUrlStore;
import org.apache.james.modules.data.SieveFileRepositoryModule;
import org.apache.james.rrt.api.AliasReverseResolver;
import org.apache.james.rrt.api.CanSendFrom;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.lib.AliasReverseResolverImpl;
import org.apache.james.rrt.lib.CanSendFromImpl;
import org.apache.james.rrt.memory.MemoryRecipientRewriteTable;
import org.apache.james.server.core.configuration.ConfigurationProvider;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.memory.MemoryUsersRepository;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;

public class MemoryDataModule
extends AbstractModule {
    protected void configure() {
        this.install((Module)new SieveFileRepositoryModule());
        this.bind(EventSourcingDLPConfigurationStore.class).in(Scopes.SINGLETON);
        this.bind(DLPConfigurationStore.class).to(EventSourcingDLPConfigurationStore.class);
        this.bind(MemoryDomainList.class).in(Scopes.SINGLETON);
        this.bind(DomainList.class).to(MemoryDomainList.class);
        this.bind(MemoryRecipientRewriteTable.class).in(Scopes.SINGLETON);
        this.bind(RecipientRewriteTable.class).to(MemoryRecipientRewriteTable.class);
        this.bind(AliasReverseResolverImpl.class).in(Scopes.SINGLETON);
        this.bind(AliasReverseResolver.class).to(AliasReverseResolverImpl.class);
        this.bind(CanSendFromImpl.class).in(Scopes.SINGLETON);
        this.bind(CanSendFrom.class).to(CanSendFromImpl.class);
        this.bind(MemoryMailRepositoryUrlStore.class).in(Scopes.SINGLETON);
        this.bind(MailRepositoryUrlStore.class).to(MemoryMailRepositoryUrlStore.class);
        this.bind(EventSourcingDLPConfigurationStore.class).in(Scopes.SINGLETON);
        this.bind(DLPConfigurationStore.class).to(EventSourcingDLPConfigurationStore.class);
        this.bind(UsersRepository.class).to(MemoryUsersRepository.class);
        this.bind(MailRepositoryStoreConfiguration.Item.class).toProvider(() -> new MailRepositoryStoreConfiguration.Item((List)ImmutableList.of((Object)new Protocol("memory")), MemoryMailRepository.class.getName(), (HierarchicalConfiguration)new BaseHierarchicalConfiguration()));
    }

    @Provides
    @Singleton
    public MemoryUsersRepository providesUsersRepository(DomainList domainList) {
        return MemoryUsersRepository.withVirtualHosting((DomainList)domainList);
    }

    @Provides
    @Singleton
    public DomainListConfiguration provideDomainListConfiguration(ConfigurationProvider configurationProvider) throws ConfigurationException {
        return DomainListConfiguration.from((HierarchicalConfiguration)configurationProvider.getConfiguration("domainlist"));
    }

    @ProvidesIntoSet
    InitializationOperation configureDomainList(DomainListConfiguration domainListConfiguration, MemoryDomainList memoryDomainList) {
        return InitilizationOperationBuilder.forClass(MemoryDomainList.class).init(() -> memoryDomainList.configure(domainListConfiguration));
    }

    @ProvidesIntoSet
    InitializationOperation configureRRT(ConfigurationProvider configurationProvider, MemoryRecipientRewriteTable memoryRecipientRewriteTable) {
        return InitilizationOperationBuilder.forClass(MemoryRecipientRewriteTable.class).init(() -> memoryRecipientRewriteTable.configure(configurationProvider.getConfiguration("recipientrewritetable")));
    }
}

