/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver;

import javax.inject.Inject;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.AbstractSenderAuthIdentifyVerificationRcptHook;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.smtpserver.ExtendedSMTPSession;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;

public class SenderAuthIdentifyVerificationRcptHook
extends AbstractSenderAuthIdentifyVerificationRcptHook {
    private DomainList domains;
    private UsersRepository users;

    @Inject
    public final void setUsersRepository(UsersRepository users) {
        this.users = users;
    }

    @Inject
    public void setDomainList(DomainList domains) {
        this.domains = domains;
    }

    public void init(Configuration config) throws ConfigurationException {
    }

    public void destroy() {
    }

    public HookResult doRcpt(SMTPSession session, MaybeSender sender, MailAddress rcpt) {
        ExtendedSMTPSession nSession = (ExtendedSMTPSession)session;
        if (nSession.verifyIdentity()) {
            return super.doRcpt(session, sender, rcpt);
        }
        return HookResult.DECLINED;
    }

    protected boolean isLocalDomain(Domain domain) {
        try {
            return this.domains.containsDomain(domain);
        }
        catch (DomainListException e) {
            return false;
        }
    }

    protected String getUser(MailAddress mailAddress) {
        try {
            return this.users.getUser(mailAddress);
        }
        catch (UsersRepositoryException e) {
            throw new RuntimeException(e);
        }
    }
}

