/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.container.spring.bean.factorypostprocessor;

import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.container.spring.lifecycle.ConfigurationProvider;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

public class IndexerConfigurationBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        ConfigurationProvider confProvider = (ConfigurationProvider)beanFactory.getBean(ConfigurationProvider.class);
        try {
            HierarchicalConfiguration config = confProvider.getConfiguration("indexer");
            String provider = config.getString("provider", "lazyIndex");
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
            String indexer = null;
            String reIndexer = null;
            if (provider.equalsIgnoreCase("lazyIndex")) {
                indexer = "lazyIndex";
                reIndexer = "fake-reindexer";
            } else if (provider.equalsIgnoreCase("elasticsearch")) {
                indexer = "elasticsearch-listener";
                reIndexer = "reindexer-impl";
            } else if (provider.equalsIgnoreCase("luceneIndex")) {
                indexer = "luceneIndex";
                reIndexer = "fake-reindexer";
            }
            if (indexer == null) {
                throw new ConfigurationException("Indexer provider " + provider + " not supported!");
            }
            registry.registerAlias(indexer, "indexer");
            registry.registerAlias(reIndexer, "reindexer");
        }
        catch (ConfigurationException e) {
            throw new FatalBeanException("Unable to config the indexer", (Throwable)e);
        }
    }
}

