/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util.concurrency;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentTestRunner {
    public static final int DEFAULT_OPERATION_COUNT = 1;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConcurrentTestRunner.class);
    private final int threadCount;
    private final int operationCount;
    private final CountDownLatch countDownLatch;
    private final ConcurrentOperation biConsumer;
    private final ExecutorService executorService;
    private final List<Future<?>> futures;

    public static RequireOperation builder() {
        return operation -> threadCount -> new Builder(threadCount, operation);
    }

    private ConcurrentTestRunner(int threadCount, int operationCount, ConcurrentOperation biConsumer) {
        this.threadCount = threadCount;
        this.operationCount = operationCount;
        this.countDownLatch = new CountDownLatch(threadCount);
        this.biConsumer = biConsumer;
        this.executorService = Executors.newFixedThreadPool(threadCount);
        this.futures = new ArrayList();
    }

    public ConcurrentTestRunner run() {
        for (int i = 0; i < this.threadCount; ++i) {
            this.futures.add(this.executorService.submit(new ConcurrentRunnableTask(i, this.biConsumer)));
        }
        return this;
    }

    public ConcurrentTestRunner assertNoException() throws ExecutionException, InterruptedException {
        for (Future<?> future : this.futures) {
            future.get();
        }
        return this;
    }

    public ConcurrentTestRunner awaitTermination(Duration duration) throws InterruptedException {
        this.executorService.shutdown();
        boolean terminated = this.executorService.awaitTermination(duration.toMillis(), TimeUnit.MILLISECONDS);
        if (!terminated) {
            throw new NotTerminatedException();
        }
        return this;
    }

    public ConcurrentTestRunner runSuccessfullyWithin(Duration duration) throws InterruptedException, ExecutionException {
        return this.run().awaitTermination(duration).assertNoException();
    }

    public ConcurrentTestRunner runAcceptingErrorsWithin(Duration duration) throws InterruptedException, ExecutionException {
        return this.run().awaitTermination(duration);
    }

    public static class NotTerminatedException
    extends RuntimeException {
    }

    private class ConcurrentRunnableTask
    implements Runnable {
        private final int threadNumber;
        private final ConcurrentOperation concurrentOperation;
        private Exception exception;

        public ConcurrentRunnableTask(int threadNumber, ConcurrentOperation concurrentOperation) {
            this.threadNumber = threadNumber;
            this.concurrentOperation = concurrentOperation;
        }

        @Override
        public void run() {
            this.exception = null;
            ConcurrentTestRunner.this.countDownLatch.countDown();
            for (int i = 0; i < ConcurrentTestRunner.this.operationCount; ++i) {
                try {
                    this.concurrentOperation.execute(this.threadNumber, i);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error("Error caught during concurrent testing", (Throwable)e);
                    this.exception = e;
                }
            }
            if (this.exception != null) {
                throw new RuntimeException(this.exception);
            }
        }
    }

    public static interface ConcurrentOperation {
        public void execute(int var1, int var2) throws Exception;
    }

    public static class Builder {
        private final int threadCount;
        private final ConcurrentOperation operation;
        private Optional<Integer> operationCount;

        private Builder(int threadCount, ConcurrentOperation operation) {
            Preconditions.checkArgument((threadCount > 0 ? 1 : 0) != 0, (Object)"Thread count should be strictly positive");
            Preconditions.checkNotNull((Object)operation);
            this.threadCount = threadCount;
            this.operation = operation;
            this.operationCount = Optional.empty();
        }

        public Builder operationCount(int operationCount) {
            Preconditions.checkArgument((operationCount > 0 ? 1 : 0) != 0, (Object)"Operation count should be strictly positive");
            this.operationCount = Optional.of(operationCount);
            return this;
        }

        private ConcurrentTestRunner build() {
            return new ConcurrentTestRunner(this.threadCount, this.operationCount.orElse(1), this.operation);
        }

        public ConcurrentTestRunner runSuccessfullyWithin(Duration duration) throws InterruptedException, ExecutionException {
            return this.build().runSuccessfullyWithin(duration);
        }

        public ConcurrentTestRunner runAcceptingErrorsWithin(Duration duration) throws InterruptedException, ExecutionException {
            return this.build().runAcceptingErrorsWithin(duration);
        }
    }

    @FunctionalInterface
    public static interface RequireThreadCount {
        public Builder threadCount(int var1);
    }

    @FunctionalInterface
    public static interface RequireOperation {
        public RequireThreadCount operation(ConcurrentOperation var1);
    }
}

