/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v1_1.config;

import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.name.Named;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.location.Provider;
import org.jclouds.location.suppliers.ImplicitRegionIdSupplier;
import org.jclouds.location.suppliers.RegionIdToURISupplier;
import org.jclouds.openstack.internal.Authentication;
import org.jclouds.openstack.keystone.v1_1.AuthenticationAsyncClient;
import org.jclouds.openstack.keystone.v1_1.AuthenticationClient;
import org.jclouds.openstack.keystone.v1_1.domain.Auth;
import org.jclouds.openstack.keystone.v1_1.handlers.RetryOnRenew;
import org.jclouds.openstack.keystone.v1_1.suppliers.RegionIdToURIFromAuthForServiceSupplier;
import org.jclouds.openstack.keystone.v1_1.suppliers.V1DefaultRegionIdSupplier;
import org.jclouds.rest.config.BinderUtils;

public class AuthenticationServiceModule
extends AbstractModule {
    protected void configure() {
        BinderUtils.bindSyncToAsyncHttpApi((Binder)this.binder(), AuthenticationClient.class, AuthenticationAsyncClient.class);
        this.install(new FactoryModuleBuilder().implement(RegionIdToURISupplier.class, RegionIdToURIFromAuthForServiceSupplier.class).build(RegionIdToURISupplier.Factory.class));
        this.install(new FactoryModuleBuilder().implement(ImplicitRegionIdSupplier.class, V1DefaultRegionIdSupplier.class).build(V1DefaultRegionIdSupplier.Factory.class));
        this.bind(HttpRetryHandler.class).annotatedWith(ClientError.class).to(RetryOnRenew.class);
    }

    @Provides
    @Singleton
    @Authentication
    protected Supplier<String> provideAuthenticationTokenCache(final Supplier<Auth> supplier) throws InterruptedException, ExecutionException, TimeoutException {
        return new Supplier<String>(){

            public String get() {
                return ((Auth)supplier.get()).getToken().getId();
            }
        };
    }

    @Provides
    @Singleton
    protected LoadingCache<Credentials, Auth> provideAuthCache(GetAuth getAuth, @Named(value="jclouds.session-interval") long sessionInterval) {
        return CacheBuilder.newBuilder().expireAfterWrite(sessionInterval, TimeUnit.SECONDS).build((CacheLoader)getAuth);
    }

    @Provides
    @Singleton
    protected Supplier<Auth> provideAuthSupplier(final LoadingCache<Credentials, Auth> cache, final @Provider Supplier<Credentials> creds) {
        return new Supplier<Auth>(){

            public Auth get() {
                return (Auth)cache.getUnchecked(creds.get());
            }
        };
    }

    @Singleton
    public static class GetAuth
    extends CacheLoader<Credentials, Auth> {
        private final AuthenticationClient client;

        @Inject
        public GetAuth(AuthenticationClient client) {
            this.client = client;
        }

        public Auth load(Credentials input) {
            return this.client.authenticate(input.identity, input.credential);
        }

        public String toString() {
            return "authenticate()";
        }
    }
}

