/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.strategy.internal;

import com.google.common.base.Throwables;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.functions.ObjectMD5;
import org.jclouds.blobstore.internal.BlobRuntimeException;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.strategy.ContainsValueInListStrategy;
import org.jclouds.blobstore.strategy.ListBlobsInContainer;

@Singleton
public class FindMD5InList
implements ContainsValueInListStrategy {
    protected final ObjectMD5 objectMD5;
    protected final ListBlobsInContainer getAllBlobMetadata;

    @Inject
    private FindMD5InList(ObjectMD5 objectMD5, ListBlobsInContainer getAllBlobMetadata) {
        this.objectMD5 = objectMD5;
        this.getAllBlobMetadata = getAllBlobMetadata;
    }

    @Override
    public boolean execute(String containerName, Object value, ListContainerOptions options) {
        try {
            byte[] toSearch = this.objectMD5.apply(value);
            for (BlobMetadata blobMetadata : this.getAllBlobMetadata.execute(containerName, options)) {
                if (!Arrays.equals(toSearch, blobMetadata.getContentMetadata().getContentMD5())) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, BlobRuntimeException.class);
            throw new BlobRuntimeException(String.format("Error searching for ETAG of value: [%2$s] in container:%1$s", containerName, value), e);
        }
    }
}

