/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.domain.internal;

import com.google.common.base.Objects;
import java.net.URI;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.MutableStorageMetadataImpl;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.io.payloads.BaseMutableContentMetadata;

public class MutableBlobMetadataImpl
extends MutableStorageMetadataImpl
implements MutableBlobMetadata {
    private MutableContentMetadata contentMetadata;
    private URI publicUri;
    private String container;

    public MutableBlobMetadataImpl() {
        this.setType(StorageType.BLOB);
        this.contentMetadata = new BaseMutableContentMetadata();
    }

    public MutableBlobMetadataImpl(BlobMetadata from) {
        super(from);
        this.contentMetadata = new BaseMutableContentMetadata();
        HttpUtils.copy((ContentMetadata)from.getContentMetadata(), (MutableContentMetadata)this.contentMetadata);
        this.publicUri = from.getPublicUri();
        this.container = from.getContainer();
    }

    @Override
    public MutableContentMetadata getContentMetadata() {
        return this.contentMetadata;
    }

    @Override
    public void setContentMetadata(MutableContentMetadata contentMetadata) {
        this.contentMetadata = contentMetadata;
    }

    @Override
    public void setPublicUri(URI publicUri) {
        this.publicUri = publicUri;
    }

    @Override
    public URI getPublicUri() {
        return this.publicUri;
    }

    @Override
    public String getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(String container) {
        this.container = container;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MutableBlobMetadataImpl)) {
            return false;
        }
        MutableBlobMetadataImpl that = (MutableBlobMetadataImpl)object;
        return super.equals(that) && Objects.equal((Object)this.contentMetadata, (Object)that.contentMetadata) && Objects.equal((Object)this.publicUri, (Object)that.publicUri) && Objects.equal((Object)this.container, (Object)that.container);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.contentMetadata, this.publicUri, this.container});
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("publicUri", (Object)this.publicUri).add("container", (Object)this.container).add("contentMetadata", (Object)this.contentMetadata);
    }
}

