/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.binders;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import org.jclouds.blobstore.binders.BindMapToHeadersWithPrefix;
import org.jclouds.http.HttpRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BindMapToHeadersWithPrefixTest {
    @Test
    public void testCorrect() throws SecurityException, NoSuchMethodException {
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://momma").build();
        BindMapToHeadersWithPrefix binder = new BindMapToHeadersWithPrefix("prefix:");
        Assert.assertEquals((Object)binder.bindToRequest(request, (Object)ImmutableMap.of((Object)"imageName", (Object)"foo", (Object)"serverId", (Object)"2")), (Object)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://momma").addHeader("prefix:imagename", new String[]{"foo"})).addHeader("prefix:serverid", new String[]{"2"})).build());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMustBeMap() {
        BindMapToHeadersWithPrefix binder = new BindMapToHeadersWithPrefix("prefix:");
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").build();
        binder.bindToRequest(request, (Object)new File("foo"));
    }

    @Test(expectedExceptions={NullPointerException.class, IllegalStateException.class})
    public void testNullIsBad() {
        BindMapToHeadersWithPrefix binder = new BindMapToHeadersWithPrefix("prefix:");
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://momma").build();
        binder.bindToRequest(request, null);
    }
}

