/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.functions;

import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.functions.BlobName;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BlobNameTest {
    BlobName fn = new BlobName();
    private static final Blob.Factory BLOB_FACTORY = (Blob.Factory)ContextBuilder.newBuilder((String)"transient").buildInjector().getInstance(Blob.Factory.class);

    @Test
    public void testCorrect() throws SecurityException, NoSuchMethodException {
        Blob blob = BLOB_FACTORY.create(null);
        blob.getMetadata().setName("foo");
        Assert.assertEquals((String)this.fn.apply(blob), (String)"foo");
    }

    @Test(expectedExceptions={NullPointerException.class, IllegalStateException.class})
    public void testNullIsBad() {
        this.fn.apply(null);
    }
}

