/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.functions;

import java.util.Date;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.http.options.GetOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BlobToHttpGetOptionsTest {
    BlobToHttpGetOptions fn = new BlobToHttpGetOptions();

    @Test
    public void testNoneReturnsNone() {
        Assert.assertEquals((Object)this.fn.apply(org.jclouds.blobstore.options.GetOptions.NONE), (Object)GetOptions.NONE);
    }

    @Test
    public void testIfUnmodifiedSince() {
        Date ifUnmodifiedSince = new Date(999999L);
        org.jclouds.blobstore.options.GetOptions in = new org.jclouds.blobstore.options.GetOptions();
        in.ifUnmodifiedSince(ifUnmodifiedSince);
        GetOptions expected = new GetOptions();
        expected.ifUnmodifiedSince(ifUnmodifiedSince);
        Assert.assertEquals((Object)this.fn.apply(in), (Object)expected);
    }

    @Test
    public void testIfModifiedSince() {
        Date ifModifiedSince = new Date(999999L);
        org.jclouds.blobstore.options.GetOptions in = new org.jclouds.blobstore.options.GetOptions();
        in.ifModifiedSince(ifModifiedSince);
        GetOptions expected = new GetOptions();
        expected.ifModifiedSince(ifModifiedSince);
        Assert.assertEquals((Object)this.fn.apply(in), (Object)expected);
    }

    public void testIfUnmatch() {
        String ifUnmatch = "foo";
        org.jclouds.blobstore.options.GetOptions in = new org.jclouds.blobstore.options.GetOptions();
        in.ifETagDoesntMatch(ifUnmatch);
        GetOptions expected = new GetOptions();
        expected.ifETagDoesntMatch(ifUnmatch);
        Assert.assertEquals((Object)this.fn.apply(in), (Object)expected);
    }

    @Test
    public void testIfMatch() {
        String ifMatch = "foo";
        org.jclouds.blobstore.options.GetOptions in = new org.jclouds.blobstore.options.GetOptions();
        in.ifETagMatches(ifMatch);
        GetOptions expected = new GetOptions();
        expected.ifETagMatches(ifMatch);
        Assert.assertEquals((Object)this.fn.apply(in), (Object)expected);
    }

    @Test
    public void testRanges() {
        org.jclouds.blobstore.options.GetOptions in = new org.jclouds.blobstore.options.GetOptions();
        in.range(0L, 1024L);
        in.startAt(2048L);
        GetOptions expected = new GetOptions();
        expected.range(0L, 1024L);
        expected.startAt(2048L);
        Assert.assertEquals((Object)this.fn.apply(in), (Object)expected);
    }

    @Test
    public void testRangesTail() {
        org.jclouds.blobstore.options.GetOptions in = new org.jclouds.blobstore.options.GetOptions();
        in.tail(1024L);
        GetOptions expected = new GetOptions();
        expected.tail(1024L);
        Assert.assertEquals((Object)this.fn.apply(in), (Object)expected);
    }

    @Test
    public void testRangesStart() {
        org.jclouds.blobstore.options.GetOptions in = new org.jclouds.blobstore.options.GetOptions();
        in.startAt(1024L);
        GetOptions expected = new GetOptions();
        expected.startAt(1024L);
        Assert.assertEquals((Object)this.fn.apply(in), (Object)expected);
    }

    @Test(expectedExceptions={NullPointerException.class, IllegalStateException.class})
    public void testNullIsBad() {
        this.fn.apply(null);
    }
}

