/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.functions;

import com.google.common.collect.ImmutableList;
import com.google.inject.Guice;
import com.google.inject.Module;
import jakarta.inject.Provider;
import java.util.Collection;
import org.easymock.EasyMock;
import org.jclouds.blobstore.config.BlobStoreObjectModule;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.internal.MutableBlobMetadataImpl;
import org.jclouds.blobstore.functions.ParseBlobFromHeadersAndHttpContent;
import org.jclouds.blobstore.functions.ParseSystemAndUserMetadataFromHeaders;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class ParseBlobFromHeadersAndHttpContentTest {
    private Blob.Factory blobProvider;
    private Provider<MutableBlobMetadata> blobMetadataProvider = new Provider<MutableBlobMetadata>(){

        public MutableBlobMetadata get() {
            return new MutableBlobMetadataImpl();
        }
    };

    @BeforeTest
    void setUp() {
        this.blobProvider = (Blob.Factory)Guice.createInjector((Module[])new Module[]{new BlobStoreObjectModule()}).getInstance(Blob.Factory.class);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testCall() throws HttpException {
        ParseSystemAndUserMetadataFromHeaders metadataParser = (ParseSystemAndUserMetadataFromHeaders)EasyMock.createMock(ParseSystemAndUserMetadataFromHeaders.class);
        ParseBlobFromHeadersAndHttpContent callable = new ParseBlobFromHeadersAndHttpContent(metadataParser, this.blobProvider);
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").addHeader("Content-Range", new String[]{null})).build();
        callable.apply(response);
    }

    @Test
    public void testParseContentLengthWhenContentRangeSet() throws HttpException {
        ParseSystemAndUserMetadataFromHeaders metadataParser = (ParseSystemAndUserMetadataFromHeaders)EasyMock.createMock(ParseSystemAndUserMetadataFromHeaders.class);
        ParseBlobFromHeadersAndHttpContent callable = new ParseBlobFromHeadersAndHttpContent(metadataParser, this.blobProvider);
        HttpResponse response = ((HttpResponse.Builder)((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload("")).addHeader("Content-Range", new String[]{"0-10485759/20232760"})).build();
        response.getPayload().getContentMetadata().setContentType("application/json");
        response.getPayload().getContentMetadata().setContentLength(Long.valueOf(0xA00000L));
        MutableBlobMetadata meta = (MutableBlobMetadata)this.blobMetadataProvider.get();
        EasyMock.expect((Object)metadataParser.apply(response)).andReturn((Object)meta);
        EasyMock.replay((Object[])new Object[]{metadataParser});
        Blob object = callable.apply(response);
        Assert.assertEquals((Object)object.getPayload().getContentMetadata().getContentLength(), (Object)0xA00000L);
        Assert.assertEquals((Collection)object.getAllHeaders().get((Object)"Content-Range"), (Collection)ImmutableList.of((Object)"0-10485759/20232760"));
    }
}

