/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.integration;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Map;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.integration.internal.BaseContainerIntegrationTest;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.domain.Location;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;

@Test(groups={"integration", "live"})
public class TransientContainerIntegrationTest
extends BaseContainerIntegrationTest {
    public TransientContainerIntegrationTest() {
        this.provider = "transient";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testNotWithDetails() throws InterruptedException {
        String key = "hello";
        Blob blob = ((BlobStoreContext)this.view).getBlobStore().blobBuilder("hello").userMetadata((Map)ImmutableMap.of((Object)"Adrian", (Object)"powderpuff")).payload(TEST_STRING).contentType("text/plain").build();
        String containerName = this.getContainerName();
        try {
            this.addBlobToContainer(containerName, blob);
            this.validateContent(containerName, key);
            PageSet container = ((BlobStoreContext)this.view).getBlobStore().list(containerName, ListContainerOptions.Builder.maxResults((int)1));
            BlobMetadata metadata = (BlobMetadata)Iterables.getOnlyElement((Iterable)container);
            Assert.assertEquals((int)metadata.getUserMetadata().size(), (int)0);
        }
        finally {
            this.returnContainer(containerName);
        }
    }

    @Test(groups={"integration", "live"})
    public void testDuplicateCreateContainer() {
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        Location location = null;
        String container = "container";
        boolean created = blobStore.createContainerInLocation(location, container);
        Assert.assertTrue((boolean)created);
        created = blobStore.createContainerInLocation(location, container);
        Assert.assertFalse((boolean)created);
    }

    @Override
    @Test(groups={"integration", "live"})
    public void testSetContainerAccess() throws Exception {
        throw new SkipException("transient does not support anonymous access");
    }
}

