/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.integration.internal;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.net.HostAndPort;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.integration.internal.BaseBlobStoreIntegrationTest;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.domain.Location;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.predicates.SocketOpen;
import org.jclouds.util.Predicates2;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;

public class BaseContainerLiveTest
extends BaseBlobStoreIntegrationTest {
    private Location defaultLocation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"live"})
    public void testPublicAccess() throws InterruptedException, MalformedURLException, IOException {
        final String containerName = this.getScratchContainerName();
        try {
            ((BlobStoreContext)this.view).getBlobStore().createContainerInLocation(null, containerName, CreateContainerOptions.Builder.publicRead());
            this.assertConsistencyAwareContainerExists(containerName);
            this.defaultLocation = ((StorageMetadata)Iterables.find((Iterable)((BlobStoreContext)this.view).getBlobStore().list(), (Predicate)new Predicate<StorageMetadata>(){

                public boolean apply(@Nullable StorageMetadata input) {
                    return input.getName().equals(containerName);
                }
            })).getLocation();
            ((BlobStoreContext)this.view).getBlobStore().putBlob(containerName, ((BlobStoreContext)this.view).getBlobStore().blobBuilder("hello").payload(TEST_STRING).build());
            this.assertConsistencyAwareContainerSize(containerName, 1);
            BlobMetadata metadata = ((BlobStoreContext)this.view).getBlobStore().blobMetadata(containerName, "hello");
            Assert.assertNotNull((Object)metadata.getPublicUri(), (String)metadata.toString());
            SocketOpen socketOpen = (SocketOpen)this.context.utils().injector().getInstance(SocketOpen.class);
            Predicate socketTester = Predicates2.retry((Predicate)socketOpen, (long)60L, (long)5L, (TimeUnit)TimeUnit.SECONDS);
            int port = metadata.getPublicUri().getPort();
            HostAndPort hostAndPort = HostAndPort.fromParts((String)metadata.getPublicUri().getHost(), (int)(port != -1 ? port : 80));
            Assert.assertTrue((boolean)socketTester.apply((Object)hostAndPort), (String)metadata.getPublicUri().toString());
            Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)((BlobStoreContext)this.view).utils().http().get(metadata.getPublicUri())), (String)TEST_STRING);
        }
        finally {
            this.recycleContainerAndAddToPool(containerName);
        }
    }

    static Location findNonDefaultLocationOrSkip(BlobStore blobStore, Location defaultLocation) {
        Iterable iterable = Iterables.filter((Iterable)blobStore.listAssignableLocations(), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)defaultLocation)));
        ArrayList locs = Lists.newArrayList((Iterable)iterable);
        if (locs.size() == 0) {
            throw new SkipException("No non-default location found in " + String.valueOf(locs));
        }
        Collections.shuffle(locs);
        return (Location)locs.get(0);
    }

    @Test(groups={"live"}, dependsOnMethods={"testPublicAccess"})
    public void testPublicAccessInNonDefaultLocation() throws InterruptedException, MalformedURLException, IOException {
        Location nonDefault = BaseContainerLiveTest.findNonDefaultLocationOrSkip(((BlobStoreContext)this.view).getBlobStore(), this.defaultLocation);
        String payload = "my data";
        this.runCreateContainerInLocation(payload, nonDefault);
    }

    @Test(groups={"live"}, dependsOnMethods={"testPublicAccess"})
    public void testPublicAccessInNonDefaultLocationWithBigBlob() throws InterruptedException, MalformedURLException, IOException {
        Location nonDefault = BaseContainerLiveTest.findNonDefaultLocationOrSkip(((BlobStoreContext)this.view).getBlobStore(), this.defaultLocation);
        String payload = Strings.repeat((String)"a", (int)0x100000);
        this.runCreateContainerInLocation(payload, nonDefault);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runCreateContainerInLocation(String payload, Location nonDefault) throws InterruptedException, IOException {
        String blobName = "hello";
        BlobStore blobStore = ((BlobStoreContext)this.view).getBlobStore();
        String containerName = this.getScratchContainerName();
        try {
            Logger.getAnonymousLogger().info(String.format("creating public container %s in location %s", containerName, nonDefault.getId()));
            blobStore.createContainerInLocation(nonDefault, containerName, CreateContainerOptions.Builder.publicRead());
            this.assertConsistencyAwareContainerExists(containerName);
            this.assertConsistencyAwareContainerInLocation(containerName, nonDefault);
            blobStore.putBlob(containerName, blobStore.blobBuilder(blobName).payload(payload).build());
            this.assertConsistencyAwareContainerSize(containerName, 1);
            BlobMetadata metadata = ((BlobStoreContext)this.view).getBlobStore().blobMetadata(containerName, blobName);
            Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)((BlobStoreContext)this.view).utils().http().get(metadata.getPublicUri())), (String)payload);
            this.assertConsistencyAwareBlobInLocation(containerName, blobName, nonDefault);
        }
        finally {
            this.recycleContainerAndAddToPool(containerName);
        }
    }
}

