/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.integration.internal;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.internal.MutableStorageMetadataImpl;
import org.jclouds.blobstore.integration.internal.BaseBlobStoreIntegrationTest;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BaseServiceIntegrationTest
extends BaseBlobStoreIntegrationTest {
    @Test(groups={"integration", "live"})
    void containerDoesntExist() {
        PageSet list = ((BlobStoreContext)this.view).getBlobStore().list();
        assert (!list.contains(new MutableStorageMetadataImpl()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"integration", "live"})
    public void testAllLocations() throws InterruptedException {
        for (final Location location : ((BlobStoreContext)this.view).getBlobStore().listAssignableLocations()) {
            final String containerName = this.getScratchContainerName();
            try {
                System.err.printf(" >> creating container in location %s%n", location);
                ((BlobStoreContext)this.view).getBlobStore().createContainerInLocation(location, containerName);
                System.err.printf(" << call complete.. checking%n", new Object[0]);
                this.assertConsistencyAware(new Runnable(){

                    @Override
                    public void run() {
                        PageSet list = ((BlobStoreContext)BaseServiceIntegrationTest.this.view).getBlobStore().list();
                        assert (Iterables.any((Iterable)list, (Predicate)new Predicate<StorageMetadata>(){

                            public boolean apply(StorageMetadata md) {
                                return containerName.equals(md.getName()) && BaseServiceIntegrationTest.this.locationEquals(location, md.getLocation());
                            }
                        })) : String.format("container %s/%s not found in list %s", location, containerName, list);
                        Assert.assertTrue((boolean)((BlobStoreContext)BaseServiceIntegrationTest.this.view).getBlobStore().containerExists(containerName), (String)containerName);
                    }
                });
            }
            finally {
                this.recycleContainerAndAddToPool(containerName);
            }
        }
    }

    protected Set<String> getIso3166Codes() {
        return ImmutableSet.of();
    }

    @Test(groups={"integration", "live"})
    public void testGetAssignableLocations() throws Exception {
        for (Location location : ((BlobStoreContext)this.view).getBlobStore().listAssignableLocations()) {
            System.err.printf("location %s%n", location);
            assert (location.getId() != null) : location;
            assert (location != location.getParent()) : location;
            assert (location.getScope() != null) : location;
            switch (location.getScope()) {
                case PROVIDER: {
                    this.assertProvider(location);
                    break;
                }
                case REGION: {
                    this.assertProvider(location.getParent());
                    assert (location.getIso3166Codes().size() == 0 || location.getParent().getIso3166Codes().containsAll(location.getIso3166Codes())) : String.valueOf(location) + " ||" + String.valueOf(location.getParent());
                    break;
                }
                case ZONE: {
                    Location provider = location.getParent().getParent();
                    if (provider == null) {
                        provider = location.getParent();
                    }
                    this.assertProvider(provider);
                    assert (location.getIso3166Codes().size() == 0 || location.getParent().getIso3166Codes().containsAll(location.getIso3166Codes())) : String.valueOf(location) + " ||" + String.valueOf(location.getParent());
                    break;
                }
                case HOST: {
                    Location provider2 = location.getParent().getParent().getParent();
                    if (provider2 == null) {
                        provider2 = location.getParent().getParent();
                    }
                    this.assertProvider(provider2);
                }
            }
        }
    }

    void assertProvider(Location provider) {
        Assert.assertEquals((Object)provider.getScope(), (Object)LocationScope.PROVIDER);
        Assert.assertEquals((Object)provider.getParent(), null);
        Assert.assertEquals((Set)provider.getIso3166Codes(), this.getIso3166Codes());
    }

    protected boolean locationEquals(Location location1, Location location2) {
        return location1.equals((Object)location2);
    }
}

