/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.strategy.internal;

import java.io.IOException;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.strategy.ListContainerStrategy;
import org.jclouds.blobstore.strategy.internal.ConcatenateContainerLists;
import org.jclouds.blobstore.strategy.internal.ListContainerAndRecurseThroughFolders;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test
public class BiggerThanPageSizeTest {
    private BlobStore blobstore;

    @BeforeTest
    void setupBlobStore() {
        this.blobstore = ((BlobStoreContext)ContextBuilder.newBuilder((String)"transient").build(BlobStoreContext.class)).getBlobStore();
    }

    public void test() throws IOException {
        this.blobstore.createContainerInLocation(null, "goodies");
        for (int i = 0; i < 1001; ++i) {
            this.blobstore.putBlob("goodies", this.blobstore.blobBuilder("" + i).payload("" + i).build());
        }
        Assert.assertEquals((long)this.blobstore.countBlobs("goodies"), (long)1001L);
        this.blobstore.clearContainer("goodies");
        Assert.assertEquals((long)this.blobstore.countBlobs("goodies"), (long)0L);
    }

    public void testStrategies() throws IOException {
        this.blobstore.createContainerInLocation(null, "poo");
        for (int i = 0; i < 1001; ++i) {
            this.blobstore.putBlob("poo", this.blobstore.blobBuilder("" + i).payload("" + i).build());
        }
        ListContainerAndRecurseThroughFolders lister = new ListContainerAndRecurseThroughFolders((ListContainerStrategy)new ConcatenateContainerLists(this.blobstore));
        Assert.assertEquals((int)lister.execute("poo", (ListContainerOptions)ListContainerOptions.NONE).size(), (int)1001);
        this.blobstore.clearContainer("poo");
        Assert.assertEquals((int)lister.execute("poo", (ListContainerOptions)ListContainerOptions.NONE).size(), (int)0);
    }
}

