/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.strategy.internal;

import com.google.common.collect.Iterables;
import com.google.inject.Injector;
import java.io.Closeable;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.strategy.internal.ConcatenateContainerLists;
import org.jclouds.util.Closeables2;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(testName="ConcatenateContainerListsTest", singleThreaded=true)
public class ConcatenateContainerListsTest {
    private BlobStore blobstore;
    private ConcatenateContainerLists concatter;

    @BeforeClass
    void setupBlobStore() {
        Injector injector = ContextBuilder.newBuilder((String)"transient").buildInjector();
        this.blobstore = (BlobStore)injector.getInstance(BlobStore.class);
        this.concatter = (ConcatenateContainerLists)injector.getInstance(ConcatenateContainerLists.class);
    }

    public void testLargerThanOnePageNoOptions() {
        this.blobstore.createContainerInLocation(null, "goodies");
        for (int i = 0; i < 1001; ++i) {
            this.blobstore.putBlob("goodies", this.blobstore.blobBuilder("" + i).payload("" + i).build());
        }
        Iterable listing = this.concatter.execute("goodies", new ListContainerOptions());
        Assert.assertEquals((int)Iterables.size((Iterable)listing), (int)1001);
    }

    public void testLargerThanOnePageInDirAndRecursive() {
        int i;
        this.blobstore.createContainerInLocation(null, "foo");
        for (i = 0; i < 1001; ++i) {
            this.blobstore.putBlob("foo", this.blobstore.blobBuilder("" + i).payload("" + i).build());
        }
        for (i = 0; i < 1001; ++i) {
            this.blobstore.putBlob("foo", this.blobstore.blobBuilder("dir/" + i).payload("" + i).build());
        }
        Iterable listing = this.concatter.execute("foo", new ListContainerOptions());
        Assert.assertEquals((int)Iterables.size((Iterable)listing), (int)1002);
        listing = this.concatter.execute("foo", ListContainerOptions.Builder.inDirectory((String)"dir"));
        Assert.assertEquals((int)Iterables.size((Iterable)listing), (int)1001);
        listing = this.concatter.execute("foo", ListContainerOptions.Builder.recursive());
        Assert.assertEquals((int)Iterables.size((Iterable)listing), (int)2002);
    }

    @AfterClass
    void close() {
        if (this.blobstore != null) {
            Closeables2.closeQuietly((Closeable)this.blobstore.getContext());
        }
    }
}

