/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.strategy.internal;

import com.google.common.collect.Iterables;
import com.google.inject.Injector;
import java.io.Closeable;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.util.Closeables2;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(testName="DelimiterTest", singleThreaded=true)
public class DelimiterTest {
    private BlobStore blobStore;

    @BeforeClass
    void setupBlobStore() {
        Injector injector = ContextBuilder.newBuilder((String)"transient").buildInjector();
        this.blobStore = (BlobStore)injector.getInstance(BlobStore.class);
    }

    @AfterClass
    void tearDownBlobStore() {
        if (this.blobStore != null) {
            Closeables2.closeQuietly((Closeable)this.blobStore.getContext());
        }
    }

    public void testDelimiterList() {
        String container = "delimiter";
        String delimiter = "--";
        this.blobStore.createContainerInLocation(null, container);
        this.blobStore.putBlob(container, this.blobStore.blobBuilder("foo").payload("").build());
        this.blobStore.putBlob(container, this.blobStore.blobBuilder("other" + delimiter + "bar").payload("").build());
        PageSet results = this.blobStore.list(container, ListContainerOptions.Builder.delimiter((String)delimiter));
        Assert.assertEquals((int)Iterables.size((Iterable)results), (int)2);
        Assert.assertEquals((Object)((StorageMetadata)Iterables.get((Iterable)results, (int)0)).getType(), (Object)StorageType.BLOB);
        Assert.assertEquals((String)((StorageMetadata)Iterables.get((Iterable)results, (int)0)).getName(), (String)"foo");
        Assert.assertEquals((Object)((StorageMetadata)Iterables.get((Iterable)results, (int)1)).getType(), (Object)StorageType.RELATIVE_PATH);
        Assert.assertEquals((String)((StorageMetadata)Iterables.get((Iterable)results, (int)1)).getName(), (String)("other" + delimiter));
    }
}

