/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.callables;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Named;
import javax.inject.Singleton;

@Singleton
public class InitScriptConfigurationForTasks {
    public static final String PROPERTY_INIT_SCRIPT_PATTERN = "jclouds.compute.init-script-pattern";
    private String basedir = "/tmp";
    private String initScriptPattern = this.basedir + "/init-%s";
    private Supplier<String> suffixSupplier;

    public static InitScriptConfigurationForTasks create() {
        return new InitScriptConfigurationForTasks();
    }

    protected InitScriptConfigurationForTasks() {
        this.appendCurrentTimeMillisToAnonymousTaskNames();
    }

    @Inject(optional=true)
    public InitScriptConfigurationForTasks initScriptPattern(@Named(value="jclouds.compute.init-script-pattern") String initScriptPattern) {
        this.initScriptPattern = (String)Preconditions.checkNotNull((Object)initScriptPattern, (Object)"initScriptPattern ex. /tmp/init-%s");
        Preconditions.checkArgument((boolean)this.initScriptPattern.startsWith("/"), (Object)"initScriptPattern must be a UNIX-style path starting at the root (/)");
        int lastSlash = initScriptPattern.lastIndexOf(47);
        this.basedir = lastSlash == 0 ? "/" : initScriptPattern.substring(0, lastSlash);
        return this;
    }

    public InitScriptConfigurationForTasks appendCurrentTimeMillisToAnonymousTaskNames() {
        this.suffixSupplier = new Supplier<String>(){

            public String get() {
                return System.currentTimeMillis() + "";
            }

            public String toString() {
                return "currentTimeMillis()";
            }
        };
        return this;
    }

    public InitScriptConfigurationForTasks appendIncrementingNumberToAnonymousTaskNames() {
        this.suffixSupplier = new Supplier<String>(){
            private final AtomicInteger integer = new AtomicInteger();

            public String get() {
                return this.integer.getAndIncrement() + "";
            }

            public String toString() {
                return "incrementingNumber()";
            }
        };
        return this;
    }

    public String getBasedir() {
        return this.basedir;
    }

    public String getInitScriptPattern() {
        return this.initScriptPattern;
    }

    public Supplier<String> getAnonymousTaskSuffixSupplier() {
        return this.suffixSupplier;
    }
}

