/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.callables;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.eventbus.EventBus;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.name.Named;
import jakarta.annotation.Resource;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jclouds.compute.callables.ScriptStillRunningException;
import org.jclouds.compute.callables.SudoAwareInitManager;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.events.StatementOnNodeCompletion;
import org.jclouds.compute.events.StatementOnNodeFailure;
import org.jclouds.compute.reference.ComputeServiceConstants;
import org.jclouds.logging.Logger;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.util.Predicates2;

public class BlockUntilInitScriptStatusIsZeroThenReturnOutput
extends AbstractFuture<ExecResponse>
implements Runnable {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final ListeningExecutorService userExecutor;
    private final EventBus eventBus;
    private final SudoAwareInitManager commandRunner;
    private Predicate<String> notRunningAnymore;

    public SudoAwareInitManager getCommandRunner() {
        return this.commandRunner;
    }

    @Inject
    public BlockUntilInitScriptStatusIsZeroThenReturnOutput(@Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, EventBus eventBus, ComputeServiceConstants.InitStatusProperties properties, @Assisted SudoAwareInitManager commandRunner) {
        this(userExecutor, eventBus, (Predicate<String>)Predicates.alwaysTrue(), commandRunner);
        this.notRunningAnymore = BlockUntilInitScriptStatusIsZeroThenReturnOutput.loopUntilTrueOrThrowCancellationException(new ExitStatusOfCommandGreaterThanZero(commandRunner), properties.initStatusMaxPeriod, properties.initStatusInitialPeriod, this);
    }

    @VisibleForTesting
    public BlockUntilInitScriptStatusIsZeroThenReturnOutput(ListeningExecutorService userExecutor, EventBus eventBus, Predicate<String> notRunningAnymore, SudoAwareInitManager commandRunner) {
        this.commandRunner = (SudoAwareInitManager)Preconditions.checkNotNull((Object)commandRunner, (Object)"commandRunner");
        this.userExecutor = (ListeningExecutorService)Preconditions.checkNotNull((Object)userExecutor, (Object)"userExecutor");
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus, (Object)"eventBus");
        this.notRunningAnymore = (Predicate)Preconditions.checkNotNull(notRunningAnymore, (Object)"notRunningAnymore");
    }

    static Predicate<String> loopUntilTrueOrThrowCancellationException(Predicate<String> predicate, long period, long maxPeriod, final AbstractFuture<ExecResponse> futureWhichMightBeCancelled) {
        return Predicates2.retry((Predicate)Predicates.and(predicate, (Predicate)new Predicate<String>(){

            public boolean apply(String in) {
                if (futureWhichMightBeCancelled.isCancelled()) {
                    throw new CancellationException(futureWhichMightBeCancelled + " is cancelled");
                }
                return true;
            }
        }), (long)period, (long)maxPeriod, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public BlockUntilInitScriptStatusIsZeroThenReturnOutput init() {
        this.userExecutor.submit((Runnable)this);
        return this;
    }

    @Override
    public void run() {
        try {
            ExecResponse exec = null;
            do {
                this.notRunningAnymore.apply((Object)"status");
                String stdout = this.commandRunner.runAction("stdout").getOutput();
                String stderr = this.commandRunner.runAction("stderr").getOutput();
                Integer exitStatus = Ints.tryParse((String)this.commandRunner.runAction("exitstatus").getOutput().trim());
                exec = new ExecResponse(stdout, stderr, exitStatus == null ? Integer.valueOf(-1) : exitStatus);
            } while (!this.isCancelled() && exec.getExitStatus() == -1);
            this.logger.debug("<< complete(%s) status(%s)", new Object[]{this.commandRunner.getStatement().getInstanceName(), exec.getExitStatus()});
            this.set(exec);
        }
        catch (Exception e) {
            this.setException(e);
        }
    }

    protected boolean set(ExecResponse value) {
        this.eventBus.post((Object)new StatementOnNodeCompletion((Statement)this.getCommandRunner().getStatement(), this.getCommandRunner().getNode(), value));
        return super.set((Object)value);
    }

    protected void interruptTask() {
        this.logger.debug("<< cancelled(%s)", new Object[]{this.commandRunner.getStatement().getInstanceName()});
        ExecResponse returnVal = this.commandRunner.refreshAndRunAction("stop");
        CancellationException e = new CancellationException(String.format("cancelled %s on node: %s; stop command had exit status: %s", this.getCommandRunner().getStatement().getInstanceName(), this.getCommandRunner().getNode().getId(), returnVal));
        this.eventBus.post((Object)new StatementOnNodeFailure((Statement)this.getCommandRunner().getStatement(), this.getCommandRunner().getNode(), e));
        super.interruptTask();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("commandRunner", (Object)this.commandRunner).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.commandRunner});
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(this.getClass())) {
            return false;
        }
        BlockUntilInitScriptStatusIsZeroThenReturnOutput that = (BlockUntilInitScriptStatusIsZeroThenReturnOutput)BlockUntilInitScriptStatusIsZeroThenReturnOutput.class.cast(o);
        return Objects.equal((Object)this.commandRunner, (Object)that.commandRunner);
    }

    public ExecResponse get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        try {
            return (ExecResponse)super.get(timeout, unit);
        }
        catch (TimeoutException e) {
            ScriptStillRunningException exception = new ScriptStillRunningException(timeout, unit, (ListenableFuture<ExecResponse>)this);
            exception.initCause(e);
            throw exception;
        }
    }

    @VisibleForTesting
    static class ExitStatusOfCommandGreaterThanZero
    implements Predicate<String> {
        private final SudoAwareInitManager commandRunner;

        ExitStatusOfCommandGreaterThanZero(SudoAwareInitManager commandRunner) {
            this.commandRunner = commandRunner;
        }

        public boolean apply(String input) {
            return this.commandRunner.runAction(input).getExitStatus() > 0;
        }
    }

    public static interface Factory {
        public BlockUntilInitScriptStatusIsZeroThenReturnOutput create(SudoAwareInitManager var1);
    }
}

