/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.extensions.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.assistedinject.Assisted;
import jakarta.annotation.Resource;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Map;
import java.util.concurrent.Executor;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.CloneImageTemplate;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.ImageTemplate;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.suppliers.ImageCacheSupplier;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.Logger;

@Beta
public class DelegatingImageExtension
implements ImageExtension {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final ImageCacheSupplier imageCache;
    private final ImageExtension delegate;
    private final ComputeServiceAdapterContextModule.AddDefaultCredentialsToImage addDefaultCredentialsToImage;
    private final Map<String, Credentials> credentialStore;

    @Inject
    DelegatingImageExtension(@Assisted ImageCacheSupplier imageCache, @Assisted ImageExtension delegate, ComputeServiceAdapterContextModule.AddDefaultCredentialsToImage addDefaultCredentialsToImage, Map<String, Credentials> credentialStore) {
        this.imageCache = imageCache;
        this.delegate = delegate;
        this.addDefaultCredentialsToImage = addDefaultCredentialsToImage;
        this.credentialStore = credentialStore;
    }

    @Override
    public ImageTemplate buildImageTemplateFromNode(String name, String id) {
        return this.delegate.buildImageTemplateFromNode(name, id);
    }

    @Override
    public ListenableFuture<Image> createImage(final ImageTemplate template) {
        ListenableFuture future = this.delegate.createImage(template);
        future = Futures.transform(future, (Function)new Function<Image, Image>(){

            public Image apply(Image input) {
                if (input.getDefaultCredentials() != null) {
                    return input;
                }
                if (template instanceof CloneImageTemplate) {
                    CloneImageTemplate cloneImageTemplate = (CloneImageTemplate)template;
                    Credentials nodeCredentials = (Credentials)DelegatingImageExtension.this.credentialStore.get("node#" + cloneImageTemplate.getSourceNodeId());
                    if (nodeCredentials != null) {
                        DelegatingImageExtension.this.logger.info(">> Adding node(%s) credentials to image(%s)...", new Object[]{cloneImageTemplate.getSourceNodeId(), cloneImageTemplate.getName()});
                        return ImageBuilder.fromImage(input).defaultCredentials(LoginCredentials.fromCredentials((Credentials)nodeCredentials)).build();
                    }
                }
                DelegatingImageExtension.this.logger.info(">> Adding default image credentials to image(%s)...", new Object[]{template.getName()});
                return DelegatingImageExtension.this.addDefaultCredentialsToImage.apply(input);
            }
        }, (Executor)MoreExecutors.directExecutor());
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Image>(){

            public void onSuccess(Image result) {
                DelegatingImageExtension.this.imageCache.registerImage(result);
            }

            public void onFailure(Throwable t) {
            }
        }, (Executor)MoreExecutors.directExecutor());
        return future;
    }

    @Override
    public boolean deleteImage(String id) {
        boolean success = this.delegate.deleteImage(id);
        if (success) {
            this.imageCache.removeImage(id);
        }
        return success;
    }

    public static interface Factory {
        public DelegatingImageExtension create(ImageCacheSupplier var1, ImageExtension var2);
    }
}

