/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.util.ComputeServiceUtils;

@Named(value="jclouds.compute.timeout.node-running")
public class PollNodeRunning
implements Function<AtomicReference<NodeMetadata>, AtomicReference<NodeMetadata>> {
    private final Predicate<AtomicReference<NodeMetadata>> nodeRunning;

    @Inject
    public PollNodeRunning(@Named(value="jclouds.compute.timeout.node-running") Predicate<AtomicReference<NodeMetadata>> nodeRunning) {
        this.nodeRunning = (Predicate)Preconditions.checkNotNull(nodeRunning, (Object)"nodeRunning");
    }

    public AtomicReference<NodeMetadata> apply(AtomicReference<NodeMetadata> node) throws IllegalStateException {
        String originalId = node.get().getId();
        NodeMetadata originalNode = node.get();
        try {
            Stopwatch stopwatch = Stopwatch.createStarted();
            if (!this.nodeRunning.apply(node)) {
                long timeWaited = stopwatch.elapsed(TimeUnit.MILLISECONDS);
                if (node.get() == null) {
                    node.set(originalNode);
                    throw new IllegalStateException(String.format("api response for node(%s) was null", originalId));
                }
                throw new IllegalStateException(String.format("node(%s) didn't achieve the status running; aborting after %d seconds with final status: %s", originalId, timeWaited / 1000L, ComputeServiceUtils.formatStatus(node.get())));
            }
        }
        catch (IllegalStateException e) {
            if (node.get().getStatus() == NodeMetadata.Status.TERMINATED) {
                throw new IllegalStateException(String.format("node(%s) terminated", originalId));
            }
            throw Throwables.propagate((Throwable)e);
        }
        return node;
    }
}

