/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Multimap;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import jakarta.annotation.Resource;
import jakarta.inject.Named;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jclouds.compute.callables.RunScriptOnNode;
import org.jclouds.compute.config.CustomizationResponse;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.functions.NodeAndTemplateOptionsToStatement;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.strategy.InitializeRunScriptOnNodeOrPlaceInBadMap;
import org.jclouds.compute.util.OpenSocketFinder;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.logging.Logger;
import org.jclouds.scriptbuilder.domain.Statement;

public class CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap
implements Callable<Void>,
Function<AtomicReference<NodeMetadata>, Void> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final Function<AtomicReference<NodeMetadata>, AtomicReference<NodeMetadata>> pollNodeRunning;
    private final InitializeRunScriptOnNodeOrPlaceInBadMap.Factory initScriptRunnerFactory;
    private final OpenSocketFinder openSocketFinder;
    @Nullable
    private final NodeAndTemplateOptionsToStatement nodeAndTemplateOptionsToStatement;
    private final TemplateOptions options;
    private AtomicReference<NodeMetadata> node;
    private final Set<NodeMetadata> goodNodes;
    private final Map<NodeMetadata, Exception> badNodes;
    private final Multimap<NodeMetadata, CustomizationResponse> customizationResponses;
    private transient boolean tainted;

    @AssistedInject
    public CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap(@Named(value="jclouds.compute.timeout.node-running") Function<AtomicReference<NodeMetadata>, AtomicReference<NodeMetadata>> pollNodeRunning, OpenSocketFinder openSocketFinder, NodeAndTemplateOptionsToStatement nodeAndTemplateOptionsToStatement, InitializeRunScriptOnNodeOrPlaceInBadMap.Factory initScriptRunnerFactory, @Assisted TemplateOptions options, @Assisted AtomicReference<NodeMetadata> node, @Assisted Set<NodeMetadata> goodNodes, @Assisted Map<NodeMetadata, Exception> badNodes, @Assisted Multimap<NodeMetadata, CustomizationResponse> customizationResponses) {
        this.nodeAndTemplateOptionsToStatement = (NodeAndTemplateOptionsToStatement)Preconditions.checkNotNull((Object)nodeAndTemplateOptionsToStatement, (Object)"nodeAndTemplateOptionsToStatement");
        this.pollNodeRunning = (Function)Preconditions.checkNotNull(pollNodeRunning, (Object)"pollNodeRunning");
        this.initScriptRunnerFactory = (InitializeRunScriptOnNodeOrPlaceInBadMap.Factory)Preconditions.checkNotNull((Object)initScriptRunnerFactory, (Object)"initScriptRunnerFactory");
        this.openSocketFinder = (OpenSocketFinder)Preconditions.checkNotNull((Object)openSocketFinder, (Object)"openSocketFinder");
        this.node = node;
        this.options = (TemplateOptions)Preconditions.checkNotNull((Object)options, (Object)"options");
        this.goodNodes = (Set)Preconditions.checkNotNull(goodNodes, (Object)"goodNodes");
        this.badNodes = (Map)Preconditions.checkNotNull(badNodes, (Object)"badNodes");
        this.customizationResponses = (Multimap)Preconditions.checkNotNull(customizationResponses, (Object)"customizationResponses");
    }

    @AssistedInject
    public CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap(@Named(value="jclouds.compute.timeout.node-running") Function<AtomicReference<NodeMetadata>, AtomicReference<NodeMetadata>> pollNodeRunning, GetNodeMetadataStrategy getNode, OpenSocketFinder openSocketFinder, NodeAndTemplateOptionsToStatement nodeAndTemplateOptionsToStatement, InitializeRunScriptOnNodeOrPlaceInBadMap.Factory initScriptRunnerFactory, @Assisted TemplateOptions options, @Assisted Set<NodeMetadata> goodNodes, @Assisted Map<NodeMetadata, Exception> badNodes, @Assisted Multimap<NodeMetadata, CustomizationResponse> customizationResponses) {
        this(pollNodeRunning, openSocketFinder, nodeAndTemplateOptionsToStatement, initScriptRunnerFactory, options, new AtomicReference<Object>(null), goodNodes, badNodes, customizationResponses);
    }

    @Override
    public Void call() {
        Preconditions.checkState((!this.tainted ? 1 : 0) != 0, (String)"this object is not designed to be reused: %s", (Object)this.toString());
        this.tainted = true;
        String originalId = this.node.get().getId();
        try {
            if (this.options.shouldBlockUntilRunning()) {
                RunScriptOnNode runner;
                this.pollNodeRunning.apply(this.node);
                Statement statement = this.nodeAndTemplateOptionsToStatement.apply(this.node.get(), this.options);
                if (statement != null && (runner = this.initScriptRunnerFactory.create(this.node.get(), statement, this.options, this.badNodes).call()) != null) {
                    ExecResponse exec = runner.call();
                    this.customizationResponses.put((Object)this.node.get(), (Object)exec);
                }
                if (this.options.getPort() > 0) {
                    this.openSocketFinder.findOpenSocketOnNode(this.node.get(), this.options.getPort(), this.options.getSeconds(), TimeUnit.SECONDS);
                }
            }
            this.logger.debug("<< customized node(%s)", new Object[]{originalId});
            this.goodNodes.add(this.node.get());
        }
        catch (Exception e) {
            this.logger.error((Throwable)e, "<< problem customizing node(%s): ", new Object[]{originalId, Throwables.getRootCause((Throwable)e).getMessage()});
            this.badNodes.put(this.node.get(), e);
        }
        return null;
    }

    public Void apply(AtomicReference<NodeMetadata> input) {
        this.node = input;
        this.call();
        return null;
    }

    public static interface Factory {
        public Callable<Void> create(TemplateOptions var1, AtomicReference<NodeMetadata> var2, Set<NodeMetadata> var3, Map<NodeMetadata, Exception> var4, Multimap<NodeMetadata, CustomizationResponse> var5);

        public Function<AtomicReference<NodeMetadata>, Void> create(TemplateOptions var1, Set<NodeMetadata> var2, Map<NodeMetadata, Exception> var3, Multimap<NodeMetadata, CustomizationResponse> var4);
    }
}

