/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.compute.strategy;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.aws.ec2.compute.AWSEC2TemplateOptions;
import org.jclouds.aws.ec2.domain.RegionNameAndPublicKeyMaterial;
import org.jclouds.aws.ec2.functions.CreatePlacementGroupIfNeeded;
import org.jclouds.aws.ec2.options.AWSRunInstancesOptions;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.options.EC2TemplateOptions;
import org.jclouds.ec2.compute.strategy.CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.ec2.options.RunInstancesOptions;
import org.jclouds.logging.Logger;

@Singleton
public class CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions
extends CreateKeyPairAndSecurityGroupsAsNeededAndReturnRunOptions {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    @VisibleForTesting
    final LoadingCache<RegionAndName, String> placementGroupMap;
    @VisibleForTesting
    final CreatePlacementGroupIfNeeded createPlacementGroupIfNeeded;
    @VisibleForTesting
    final Function<RegionNameAndPublicKeyMaterial, KeyPair> importExistingKeyPair;
    public static final Predicate<TemplateOptions> hasPublicKeyMaterial = new Predicate<TemplateOptions>(){

        public boolean apply(TemplateOptions options) {
            return options.getPublicKey() != null;
        }
    };
    public static final Predicate<TemplateOptions> doesntNeedSshAfterImportingPublicKey = new Predicate<TemplateOptions>(){

        public boolean apply(TemplateOptions options) {
            return options.getRunScript() == null && options.getPrivateKey() == null;
        }
    };
    public static final Predicate<TemplateOptions> hasLoginCredential = new Predicate<TemplateOptions>(){

        public boolean apply(TemplateOptions options) {
            return options.getLoginPrivateKey() != null;
        }
    };

    @Inject
    public CreateKeyPairPlacementAndSecurityGroupsAsNeededAndReturnRunOptions(Function<RegionAndName, KeyPair> makeKeyPair, ConcurrentMap<RegionAndName, KeyPair> credentialsMap, @Named(value="SECURITY") LoadingCache<RegionAndName, String> securityGroupMap, Provider<RunInstancesOptions> optionsProvider, @Named(value="PLACEMENT") LoadingCache<RegionAndName, String> placementGroupMap, CreatePlacementGroupIfNeeded createPlacementGroupIfNeeded, Function<RegionNameAndPublicKeyMaterial, KeyPair> importExistingKeyPair, GroupNamingConvention.Factory namingConvention) {
        super(makeKeyPair, credentialsMap, securityGroupMap, optionsProvider, namingConvention);
        this.placementGroupMap = placementGroupMap;
        this.createPlacementGroupIfNeeded = createPlacementGroupIfNeeded;
        this.importExistingKeyPair = importExistingKeyPair;
    }

    public AWSRunInstancesOptions execute(String region, String group, Template template) {
        AWSEC2TemplateOptions awsTemplateOptions;
        String placementGroupName;
        AWSRunInstancesOptions instanceOptions = (AWSRunInstancesOptions)((Object)AWSRunInstancesOptions.class.cast(super.execute(region, group, template)));
        String string = placementGroupName = template.getHardware().getId().startsWith("cc") ? this.createNewPlacementGroupUnlessUserSpecifiedOtherwise(region, group, template.getOptions()) : null;
        if (placementGroupName != null) {
            instanceOptions.inPlacementGroup(placementGroupName);
        }
        if ((awsTemplateOptions = (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(template.getOptions())).isMonitoringEnabled()) {
            instanceOptions.enableMonitoring();
        }
        if (awsTemplateOptions.getIAMInstanceProfileArn() != null) {
            instanceOptions.withIAMInstanceProfileArn(awsTemplateOptions.getIAMInstanceProfileArn());
        }
        if (awsTemplateOptions.getIAMInstanceProfileName() != null) {
            instanceOptions.withIAMInstanceProfileName(awsTemplateOptions.getIAMInstanceProfileName());
        }
        if (awsTemplateOptions.getPrivateIpAddress() != null) {
            instanceOptions.withPrivateIpAddress(awsTemplateOptions.getPrivateIpAddress());
        }
        return instanceOptions;
    }

    @VisibleForTesting
    String createNewPlacementGroupUnlessUserSpecifiedOtherwise(String region, String group, TemplateOptions options) {
        String placementGroupName = null;
        boolean shouldAutomaticallyCreatePlacementGroup = true;
        if (options instanceof EC2TemplateOptions && (placementGroupName = ((AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(options)).getPlacementGroup()) == null) {
            shouldAutomaticallyCreatePlacementGroup = ((AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(options)).shouldAutomaticallyCreatePlacementGroup();
        }
        if (placementGroupName == null && shouldAutomaticallyCreatePlacementGroup) {
            placementGroupName = String.format("jclouds#%s#%s", group, region);
            RegionAndName regionAndName = new RegionAndName(region, placementGroupName);
            this.placementGroupMap.getUnchecked((Object)regionAndName);
        }
        return placementGroupName;
    }

    public String createNewKeyPairUnlessUserSpecifiedOtherwise(String region, String group, TemplateOptions options) {
        KeyPair pair;
        RegionAndName key = new RegionAndName(region, group);
        if (Predicates.and(hasPublicKeyMaterial, (Predicate)Predicates.or(doesntNeedSshAfterImportingPublicKey, hasLoginCredential)).apply((Object)options)) {
            pair = (KeyPair)this.importExistingKeyPair.apply((Object)new RegionNameAndPublicKeyMaterial(region, group, options.getPublicKey()));
            options.dontAuthorizePublicKey();
            if (hasLoginCredential.apply((Object)options)) {
                pair = pair.toBuilder().keyMaterial(options.getLoginPrivateKey()).build();
            }
        } else {
            if (hasPublicKeyMaterial.apply((Object)options)) {
                this.logger.warn("to avoid creating temporary keys in aws-ec2, use templateOption overrideLoginCredentialWith(id_rsa)", new Object[0]);
            }
            return super.createNewKeyPairUnlessUserSpecifiedOtherwise(region, group, options);
        }
        this.credentialsMap.put(key, pair);
        return pair.getKeyName();
    }

    protected boolean userSpecifiedTheirOwnGroups(TemplateOptions options) {
        return options instanceof AWSEC2TemplateOptions && !((AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(options)).getGroupIds().isEmpty() || super.userSpecifiedTheirOwnGroups(options);
    }

    protected void addSecurityGroups(String region, String group, Template template, RunInstancesOptions instanceOptions) {
        String subnetId;
        AWSEC2TemplateOptions awsTemplateOptions = (AWSEC2TemplateOptions)AWSEC2TemplateOptions.class.cast(template.getOptions());
        AWSRunInstancesOptions awsInstanceOptions = (AWSRunInstancesOptions)((Object)AWSRunInstancesOptions.class.cast(instanceOptions));
        if (!awsTemplateOptions.getGroupIds().isEmpty()) {
            awsInstanceOptions.withSecurityGroupIds(awsTemplateOptions.getGroupIds());
        }
        if ((subnetId = awsTemplateOptions.getSubnetId()) != null) {
            ((AWSRunInstancesOptions)((Object)AWSRunInstancesOptions.class.cast(instanceOptions))).withSubnetId(subnetId);
        } else {
            super.addSecurityGroups(region, group, template, instanceOptions);
        }
    }
}

