/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore.functions;

import com.google.common.base.Function;
import jakarta.inject.Singleton;
import java.util.Map;
import org.jclouds.azureblob.domain.MutableBlobProperties;
import org.jclouds.azureblob.domain.internal.MutableBlobPropertiesImpl;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.MutableContentMetadata;

@Singleton
public class BlobMetadataToBlobProperties
implements Function<BlobMetadata, MutableBlobProperties> {
    public MutableBlobProperties apply(BlobMetadata from) {
        if (from == null) {
            return null;
        }
        MutableBlobPropertiesImpl to = new MutableBlobPropertiesImpl();
        HttpUtils.copy((ContentMetadata)from.getContentMetadata(), (MutableContentMetadata)to.getContentMetadata());
        to.setETag(from.getETag());
        to.setName(from.getName());
        to.setUrl(from.getUri());
        to.setLastModified(from.getLastModified());
        if (from.getUserMetadata() != null) {
            for (Map.Entry entry : from.getUserMetadata().entrySet()) {
                to.getMetadata().put(((String)entry.getKey()).toLowerCase(), (String)entry.getValue());
            }
        }
        return to;
    }
}

