/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.config;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import org.jclouds.azure.storage.config.AuthType;
import org.jclouds.azureblob.domain.AzureBlob;
import org.jclouds.azureblob.domain.MutableBlobProperties;
import org.jclouds.azureblob.domain.internal.AzureBlobImpl;
import org.jclouds.blobstore.config.BlobStoreObjectModule;

public class AzureBlobModule
extends AbstractModule {
    protected void configure() {
        this.install((Module)new BlobStoreObjectModule());
        this.bind(AzureBlob.Factory.class).to(AzureBlobFactory.class).in(Scopes.SINGLETON);
    }

    @Provides
    final AzureBlob provideAzureBlob(AzureBlob.Factory factory) {
        return factory.create(null);
    }

    @Inject
    @Provides
    final AuthType AuthTypeFromPropertyOrDefault(@Named(value="jclouds.azureblob.auth") String authType) {
        return AuthType.fromValue(authType);
    }

    private static class AzureBlobFactory
    implements AzureBlob.Factory {
        @Inject
        Provider<MutableBlobProperties> metadataProvider;

        private AzureBlobFactory() {
        }

        @Override
        public AzureBlob create(MutableBlobProperties metadata) {
            return new AzureBlobImpl(metadata != null ? metadata : (MutableBlobProperties)this.metadataProvider.get());
        }
    }
}

