/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import java.util.List;
import org.jclouds.azurecompute.arm.domain.AlertModificationItem;
import org.jclouds.azurecompute.arm.domain.AlertModificationProperties;

final class AutoValue_AlertModificationProperties
extends AlertModificationProperties {
    private final String alertId;
    private final List<AlertModificationItem> modifications;

    private AutoValue_AlertModificationProperties(String alertId, List<AlertModificationItem> modifications) {
        this.alertId = alertId;
        this.modifications = modifications;
    }

    @Override
    public String alertId() {
        return this.alertId;
    }

    @Override
    public List<AlertModificationItem> modifications() {
        return this.modifications;
    }

    public String toString() {
        return "AlertModificationProperties{alertId=" + this.alertId + ", modifications=" + this.modifications + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AlertModificationProperties) {
            AlertModificationProperties that = (AlertModificationProperties)o;
            return this.alertId.equals(that.alertId()) && this.modifications.equals(that.modifications());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.alertId.hashCode();
        h *= 1000003;
        return h ^= this.modifications.hashCode();
    }

    @Override
    public AlertModificationProperties.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends AlertModificationProperties.Builder {
        private String alertId;
        private List<AlertModificationItem> modifications;

        Builder() {
        }

        private Builder(AlertModificationProperties source) {
            this.alertId = source.alertId();
            this.modifications = source.modifications();
        }

        @Override
        public AlertModificationProperties.Builder alertId(String alertId) {
            if (alertId == null) {
                throw new NullPointerException("Null alertId");
            }
            this.alertId = alertId;
            return this;
        }

        @Override
        public AlertModificationProperties.Builder modifications(List<AlertModificationItem> modifications) {
            if (modifications == null) {
                throw new NullPointerException("Null modifications");
            }
            this.modifications = modifications;
            return this;
        }

        @Override
        public AlertModificationProperties build() {
            String missing = "";
            if (this.alertId == null) {
                missing = missing + " alertId";
            }
            if (this.modifications == null) {
                missing = missing + " modifications";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_AlertModificationProperties(this.alertId, this.modifications);
        }
    }
}

