/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.domain;

import java.util.List;
import org.jclouds.azurecompute.arm.domain.AutoValue_MetricAlertCriteria;
import org.jclouds.azurecompute.arm.domain.DynamicThresholdFailingPeriods;
import org.jclouds.azurecompute.arm.domain.MetricDimension;
import org.jclouds.azurecompute.arm.util.GetEnumValue;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class MetricAlertCriteria {
    @Nullable
    public abstract String criterionType();

    @Nullable
    public abstract List<MetricDimension> dimensions();

    @Nullable
    public abstract String metricName();

    @Nullable
    public abstract String metricNamespace();

    @Nullable
    public abstract String name();

    @Nullable
    public abstract Operator operator();

    public abstract boolean skipMetricValidation();

    public abstract int threshold();

    @Nullable
    public abstract AggregationTypeEnum timeAggregation();

    @Nullable
    public abstract DynamicThresholdSensitivity alertSensitivity();

    @Nullable
    public abstract DynamicThresholdFailingPeriods failingPeriods();

    @Nullable
    public abstract String ignoreDataBefore();

    @Nullable
    public abstract String componentId();

    public abstract int failedLocationCount();

    @Nullable
    public abstract String webTestId();

    @SerializedNames(value={"criterionType", "dimensions", "metricName", "metricNamespace", "name", "operator", "skipMetricValidation", "threshold", "timeAggregation", "alertSensitivity", "failingPeriods", "ignoreDataBefore", "componentId", "failedLocationCount", "webTestId"})
    public static MetricAlertCriteria create(String criterionType, List<MetricDimension> dimensions, String metricName, String metricNamespace, String name, Operator operator, boolean skipMetricValidation, int threshold, AggregationTypeEnum timeAggregation, DynamicThresholdSensitivity alertSensitivity, DynamicThresholdFailingPeriods failingPeriods, String ignoreDataBefore, String componentId, int failedLocationCount, String webTestId) {
        return new AutoValue_MetricAlertCriteria(criterionType, dimensions, metricName, metricNamespace, name, operator, skipMetricValidation, threshold, timeAggregation, alertSensitivity, failingPeriods, ignoreDataBefore, componentId, failedLocationCount, webTestId);
    }

    public static enum DynamicThresholdOperator {
        GreaterOrLessThan,
        GreaterThan,
        LessThan;


        public static DynamicThresholdOperator fromValue(String text) {
            return (DynamicThresholdOperator)GetEnumValue.fromValueOrDefault(text, GreaterOrLessThan);
        }
    }

    public static enum DynamicThresholdSensitivity {
        High,
        Low,
        Medium;


        public static DynamicThresholdSensitivity fromValue(String text) {
            return (DynamicThresholdSensitivity)GetEnumValue.fromValueOrDefault(text, High);
        }
    }

    public static enum Operator {
        Equals,
        GreaterThan,
        GreaterThanOrEqual,
        LessThan,
        LessThanOrEqual,
        GreaterOrLessThan;


        public static Operator fromValue(String text) {
            return (Operator)GetEnumValue.fromValueOrDefault(text, Equals);
        }
    }

    public static enum AggregationTypeEnum {
        Average,
        Count,
        Maximum,
        Minimum,
        Total;


        public static AggregationTypeEnum fromValue(String text) {
            return (AggregationTypeEnum)GetEnumValue.fromValueOrDefault(text, Average);
        }
    }
}

