/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azurecompute.arm.features;

import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.azurecompute.arm.domain.MetricAlert;
import org.jclouds.azurecompute.arm.domain.MetricAlertProperties;
import org.jclouds.azurecompute.arm.filters.ApiVersionFilter;
import org.jclouds.azurecompute.arm.functions.URIParser;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.binders.BindToJsonPayload;

@Path(value="/resourcegroups/{resourcegroup}/providers/Microsoft.Insights/metricAlerts")
@RequestFilters(value={OAuthFilter.class, ApiVersionFilter.class})
@Consumes(value={"application/json"})
public interface MetricAlertApi {
    @Named(value="metricalert:get")
    @GET
    @Path(value="/{name}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public MetricAlert get(@PathParam(value="name") String var1);

    @Named(value="metricalert:list")
    @GET
    @SelectJson(value={"value"})
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<MetricAlert> list();

    @Named(value="metricalert:createOrUpdate")
    @PUT
    @MapBinder(value=BindToJsonPayload.class)
    @Path(value="/{ruleName}")
    @QueryParams(keys={"validating"}, values={"false"})
    public MetricAlert createOrUpdate(@PathParam(value="ruleName") String var1, @PayloadParam(value="properties") MetricAlertProperties var2, @PayloadParam(value="tags") Map<String, String> var3, @PayloadParam(value="location") String var4);

    @Named(value="metricalert:delete")
    @DELETE
    @Path(value="/{ruleName}")
    @ResponseParser(value=URIParser.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public URI delete(@PathParam(value="ruleName") String var1);
}

