
package org.jclouds.b2.domain;

import java.util.List;
import org.jclouds.javax.annotation.Nullable;

 final class AutoValue_B2ObjectList extends B2ObjectList {

  private final List<B2ObjectList.Entry> files;
  private final String nextFileId;
  private final String nextFileName;

  AutoValue_B2ObjectList(
      List<B2ObjectList.Entry> files,
      @Nullable String nextFileId,
      @Nullable String nextFileName) {
    if (files == null) {
      throw new NullPointerException("Null files");
    }
    this.files = files;
    this.nextFileId = nextFileId;
    this.nextFileName = nextFileName;
  }

  @Override
  public List<B2ObjectList.Entry> files() {
    return files;
  }

  @Nullable
  @Override
  public String nextFileId() {
    return nextFileId;
  }

  @Nullable
  @Override
  public String nextFileName() {
    return nextFileName;
  }

  @Override
  public String toString() {
    return "B2ObjectList{"
        + "files=" + files + ", "
        + "nextFileId=" + nextFileId + ", "
        + "nextFileName=" + nextFileName
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof B2ObjectList) {
      B2ObjectList that = (B2ObjectList) o;
      return (this.files.equals(that.files()))
           && ((this.nextFileId == null) ? (that.nextFileId() == null) : this.nextFileId.equals(that.nextFileId()))
           && ((this.nextFileName == null) ? (that.nextFileName() == null) : this.nextFileName.equals(that.nextFileName()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.files.hashCode();
    h *= 1000003;
    h ^= (nextFileId == null) ? 0 : this.nextFileId.hashCode();
    h *= 1000003;
    h ^= (nextFileName == null) ? 0 : this.nextFileName.hashCode();
    return h;
  }

}
