
package org.jclouds.b2.domain;

 final class AutoValue_DeleteFileResponse extends DeleteFileResponse {

  private final String fileName;
  private final String fileId;

  AutoValue_DeleteFileResponse(
      String fileName,
      String fileId) {
    if (fileName == null) {
      throw new NullPointerException("Null fileName");
    }
    this.fileName = fileName;
    if (fileId == null) {
      throw new NullPointerException("Null fileId");
    }
    this.fileId = fileId;
  }

  @Override
  public String fileName() {
    return fileName;
  }

  @Override
  public String fileId() {
    return fileId;
  }

  @Override
  public String toString() {
    return "DeleteFileResponse{"
        + "fileName=" + fileName + ", "
        + "fileId=" + fileId
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof DeleteFileResponse) {
      DeleteFileResponse that = (DeleteFileResponse) o;
      return (this.fileName.equals(that.fileName()))
           && (this.fileId.equals(that.fileId()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.fileName.hashCode();
    h *= 1000003;
    h ^= this.fileId.hashCode();
    return h;
  }

}
