
package org.jclouds.digitalocean2.domain;

import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import org.jclouds.javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_Droplet extends Droplet {

  private final int id;
  private final String name;
  private final int memory;
  private final int vcpus;
  private final int disk;
  private final boolean locked;
  private final Date createdAt;
  private final Droplet.Status status;
  private final List<Integer> backupsIds;
  private final List<Integer> snapshotIds;
  private final List<String> features;
  private final Region region;
  private final Image image;
  private final Size size;
  private final String sizeSlug;
  private final Networks networks;
  private final Kernel kernel;

  AutoValue_Droplet(
      int id,
      String name,
      int memory,
      int vcpus,
      int disk,
      boolean locked,
      Date createdAt,
      Droplet.Status status,
      List<Integer> backupsIds,
      List<Integer> snapshotIds,
      List<String> features,
      @Nullable Region region,
      @Nullable Image image,
      @Nullable Size size,
      String sizeSlug,
      @Nullable Networks networks,
      @Nullable Kernel kernel) {
    this.id = id;
    if (name == null) {
      throw new NullPointerException("Null name");
    }
    this.name = name;
    this.memory = memory;
    this.vcpus = vcpus;
    this.disk = disk;
    this.locked = locked;
    if (createdAt == null) {
      throw new NullPointerException("Null createdAt");
    }
    this.createdAt = createdAt;
    if (status == null) {
      throw new NullPointerException("Null status");
    }
    this.status = status;
    if (backupsIds == null) {
      throw new NullPointerException("Null backupsIds");
    }
    this.backupsIds = backupsIds;
    if (snapshotIds == null) {
      throw new NullPointerException("Null snapshotIds");
    }
    this.snapshotIds = snapshotIds;
    if (features == null) {
      throw new NullPointerException("Null features");
    }
    this.features = features;
    this.region = region;
    this.image = image;
    this.size = size;
    if (sizeSlug == null) {
      throw new NullPointerException("Null sizeSlug");
    }
    this.sizeSlug = sizeSlug;
    this.networks = networks;
    this.kernel = kernel;
  }

  @Override
  public int id() {
    return id;
  }

  @Override
  public String name() {
    return name;
  }

  @Override
  public int memory() {
    return memory;
  }

  @Override
  public int vcpus() {
    return vcpus;
  }

  @Override
  public int disk() {
    return disk;
  }

  @Override
  public boolean locked() {
    return locked;
  }

  @Override
  public Date createdAt() {
    return createdAt;
  }

  @Override
  public Droplet.Status status() {
    return status;
  }

  @Override
  public List<Integer> backupsIds() {
    return backupsIds;
  }

  @Override
  public List<Integer> snapshotIds() {
    return snapshotIds;
  }

  @Override
  public List<String> features() {
    return features;
  }

  @Nullable
  @Override
  public Region region() {
    return region;
  }

  @Nullable
  @Override
  public Image image() {
    return image;
  }

  @Nullable
  @Override
  public Size size() {
    return size;
  }

  @Override
  public String sizeSlug() {
    return sizeSlug;
  }

  @Nullable
  @Override
  public Networks networks() {
    return networks;
  }

  @Nullable
  @Override
  public Kernel kernel() {
    return kernel;
  }

  @Override
  public String toString() {
    return "Droplet{"
        + "id=" + id + ", "
        + "name=" + name + ", "
        + "memory=" + memory + ", "
        + "vcpus=" + vcpus + ", "
        + "disk=" + disk + ", "
        + "locked=" + locked + ", "
        + "createdAt=" + createdAt + ", "
        + "status=" + status + ", "
        + "backupsIds=" + backupsIds + ", "
        + "snapshotIds=" + snapshotIds + ", "
        + "features=" + features + ", "
        + "region=" + region + ", "
        + "image=" + image + ", "
        + "size=" + size + ", "
        + "sizeSlug=" + sizeSlug + ", "
        + "networks=" + networks + ", "
        + "kernel=" + kernel
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Droplet) {
      Droplet that = (Droplet) o;
      return (this.id == that.id())
           && (this.name.equals(that.name()))
           && (this.memory == that.memory())
           && (this.vcpus == that.vcpus())
           && (this.disk == that.disk())
           && (this.locked == that.locked())
           && (this.createdAt.equals(that.createdAt()))
           && (this.status.equals(that.status()))
           && (this.backupsIds.equals(that.backupsIds()))
           && (this.snapshotIds.equals(that.snapshotIds()))
           && (this.features.equals(that.features()))
           && ((this.region == null) ? (that.region() == null) : this.region.equals(that.region()))
           && ((this.image == null) ? (that.image() == null) : this.image.equals(that.image()))
           && ((this.size == null) ? (that.size() == null) : this.size.equals(that.size()))
           && (this.sizeSlug.equals(that.sizeSlug()))
           && ((this.networks == null) ? (that.networks() == null) : this.networks.equals(that.networks()))
           && ((this.kernel == null) ? (that.kernel() == null) : this.kernel.equals(that.kernel()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.id;
    h *= 1000003;
    h ^= this.name.hashCode();
    h *= 1000003;
    h ^= this.memory;
    h *= 1000003;
    h ^= this.vcpus;
    h *= 1000003;
    h ^= this.disk;
    h *= 1000003;
    h ^= this.locked ? 1231 : 1237;
    h *= 1000003;
    h ^= this.createdAt.hashCode();
    h *= 1000003;
    h ^= this.status.hashCode();
    h *= 1000003;
    h ^= this.backupsIds.hashCode();
    h *= 1000003;
    h ^= this.snapshotIds.hashCode();
    h *= 1000003;
    h ^= this.features.hashCode();
    h *= 1000003;
    h ^= (region == null) ? 0 : this.region.hashCode();
    h *= 1000003;
    h ^= (image == null) ? 0 : this.image.hashCode();
    h *= 1000003;
    h ^= (size == null) ? 0 : this.size.hashCode();
    h *= 1000003;
    h ^= this.sizeSlug.hashCode();
    h *= 1000003;
    h ^= (networks == null) ? 0 : this.networks.hashCode();
    h *= 1000003;
    h ^= (kernel == null) ? 0 : this.kernel.hashCode();
    return h;
  }

}
