
package org.jclouds.digitalocean2.domain;

import java.util.Date;
import java.util.List;
import javax.annotation.Generated;
import org.jclouds.javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_Snapshot extends Snapshot {

  private final int id;
  private final String name;
  private final String type;
  private final String distribution;
  private final String slug;
  private final boolean isPublic;
  private final List<String> regions;
  private final int minDiskSize;
  private final Date createdAt;

  AutoValue_Snapshot(
      int id,
      String name,
      String type,
      String distribution,
      @Nullable String slug,
      boolean isPublic,
      List<String> regions,
      int minDiskSize,
      Date createdAt) {
    this.id = id;
    if (name == null) {
      throw new NullPointerException("Null name");
    }
    this.name = name;
    if (type == null) {
      throw new NullPointerException("Null type");
    }
    this.type = type;
    if (distribution == null) {
      throw new NullPointerException("Null distribution");
    }
    this.distribution = distribution;
    this.slug = slug;
    this.isPublic = isPublic;
    if (regions == null) {
      throw new NullPointerException("Null regions");
    }
    this.regions = regions;
    this.minDiskSize = minDiskSize;
    if (createdAt == null) {
      throw new NullPointerException("Null createdAt");
    }
    this.createdAt = createdAt;
  }

  @Override
  public int id() {
    return id;
  }

  @Override
  public String name() {
    return name;
  }

  @Override
  public String type() {
    return type;
  }

  @Override
  public String distribution() {
    return distribution;
  }

  @Nullable
  @Override
  public String slug() {
    return slug;
  }

  @Override
  public boolean isPublic() {
    return isPublic;
  }

  @Override
  public List<String> regions() {
    return regions;
  }

  @Override
  public int minDiskSize() {
    return minDiskSize;
  }

  @Override
  public Date createdAt() {
    return createdAt;
  }

  @Override
  public String toString() {
    return "Snapshot{"
        + "id=" + id + ", "
        + "name=" + name + ", "
        + "type=" + type + ", "
        + "distribution=" + distribution + ", "
        + "slug=" + slug + ", "
        + "isPublic=" + isPublic + ", "
        + "regions=" + regions + ", "
        + "minDiskSize=" + minDiskSize + ", "
        + "createdAt=" + createdAt
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Snapshot) {
      Snapshot that = (Snapshot) o;
      return (this.id == that.id())
           && (this.name.equals(that.name()))
           && (this.type.equals(that.type()))
           && (this.distribution.equals(that.distribution()))
           && ((this.slug == null) ? (that.slug() == null) : this.slug.equals(that.slug()))
           && (this.isPublic == that.isPublic())
           && (this.regions.equals(that.regions()))
           && (this.minDiskSize == that.minDiskSize())
           && (this.createdAt.equals(that.createdAt()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.id;
    h *= 1000003;
    h ^= this.name.hashCode();
    h *= 1000003;
    h ^= this.type.hashCode();
    h *= 1000003;
    h ^= this.distribution.hashCode();
    h *= 1000003;
    h ^= (slug == null) ? 0 : this.slug.hashCode();
    h *= 1000003;
    h ^= this.isPublic ? 1231 : 1237;
    h *= 1000003;
    h ^= this.regions.hashCode();
    h *= 1000003;
    h ^= this.minDiskSize;
    h *= 1000003;
    h ^= this.createdAt.hashCode();
    return h;
  }

}
