/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.jclouds.dynect.v3.domain.Record;

public class CreateRecord<D extends Map<String, Object>> {
    private final String fqdn;
    private final String type;
    private final int ttl;
    private final D rdata;

    private CreateRecord(String fqdn, String type, int ttl, D rdata) {
        this.fqdn = (String)Preconditions.checkNotNull((Object)fqdn, (Object)"fqdn");
        this.type = (String)Preconditions.checkNotNull((Object)type, (String)"type of %s", (Object[])new Object[]{fqdn});
        Preconditions.checkArgument((ttl >= 0 ? 1 : 0) != 0, (String)"ttl of %s must be unsigned", (Object[])new Object[]{fqdn});
        this.ttl = ttl;
        this.rdata = (Map)Preconditions.checkNotNull(rdata, (String)"rdata of %s", (Object[])new Object[]{fqdn});
    }

    public String getFQDN() {
        return this.fqdn;
    }

    public String getType() {
        return this.type;
    }

    public int getTTL() {
        return this.ttl;
    }

    public D getRData() {
        return this.rdata;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof CreateRecord)) {
            return false;
        }
        CreateRecord that = (CreateRecord)CreateRecord.class.cast(obj);
        return Objects.equal((Object)this.fqdn, (Object)that.fqdn) && Objects.equal((Object)this.type, (Object)that.type) && Objects.equal((Object)this.ttl, (Object)that.ttl) && Objects.equal(this.rdata, that.rdata);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("fqdn", (Object)this.fqdn).add("type", (Object)this.type).add("ttl", this.ttl).add("rdata", this.rdata).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fqdn, this.type, this.ttl, this.rdata});
    }

    public static <D extends Map<String, Object>> Builder<D> builder() {
        return new Builder();
    }

    public Builder<D> toBuilder() {
        return new Builder().from(this);
    }

    /* synthetic */ CreateRecord(String x0, String x1, int x2, Map x3, 1 x4) {
        this(x0, x1, x2, x3);
    }

    public static class Builder<D extends Map<String, Object>> {
        protected String fqdn;
        protected String type;
        protected int ttl = 0;
        protected D rdata;

        public Builder<D> fqdn(String fqdn) {
            this.fqdn = fqdn;
            return this;
        }

        public Builder<D> type(String type) {
            this.type = type;
            return this;
        }

        public Builder<D> ttl(int ttl) {
            this.ttl = ttl;
            return this;
        }

        public Builder<D> rdata(D rdata) {
            this.rdata = rdata;
            return this;
        }

        public CreateRecord<D> build() {
            return new CreateRecord(this.fqdn, this.type, this.ttl, (Map)this.rdata, null);
        }

        public <Y extends D> Builder<D> from(CreateRecord<Y> in) {
            return this.fqdn(((CreateRecord)in).fqdn).type(((CreateRecord)in).type).ttl(((CreateRecord)in).ttl).rdata(((CreateRecord)in).rdata);
        }

        public <Y extends D> Builder<D> from(Record<Y> in) {
            return this.fqdn(in.getFQDN()).type(in.getType()).ttl(in.getTTL()).rdata(in.getRData());
        }
    }
}

