/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.features;

import com.google.common.collect.FluentIterable;
import java.util.Map;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.dynect.v3.DynECTExceptions;
import org.jclouds.dynect.v3.binders.CreateRecordBinder;
import org.jclouds.dynect.v3.binders.RecordIdBinder;
import org.jclouds.dynect.v3.domain.CreateRecord;
import org.jclouds.dynect.v3.domain.Job;
import org.jclouds.dynect.v3.domain.Record;
import org.jclouds.dynect.v3.domain.RecordId;
import org.jclouds.dynect.v3.domain.SOARecord;
import org.jclouds.dynect.v3.domain.rdata.AAAAData;
import org.jclouds.dynect.v3.domain.rdata.AData;
import org.jclouds.dynect.v3.domain.rdata.CNAMEData;
import org.jclouds.dynect.v3.domain.rdata.MXData;
import org.jclouds.dynect.v3.domain.rdata.NSData;
import org.jclouds.dynect.v3.domain.rdata.PTRData;
import org.jclouds.dynect.v3.domain.rdata.SPFData;
import org.jclouds.dynect.v3.domain.rdata.SRVData;
import org.jclouds.dynect.v3.domain.rdata.SSHFPData;
import org.jclouds.dynect.v3.domain.rdata.TXTData;
import org.jclouds.dynect.v3.filters.AlwaysAddContentType;
import org.jclouds.dynect.v3.filters.SessionManager;
import org.jclouds.dynect.v3.functions.ToRecordIds;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;

@Headers(keys={"API-Version"}, values={"{jclouds.api-version}"})
@RequestFilters(value={AlwaysAddContentType.class, SessionManager.class})
public interface RecordApi {
    @Named(value="GetAllRecord")
    @GET
    @Path(value="/AllRecord/{zone}")
    @ResponseParser(value=ToRecordIds.class)
    public FluentIterable<RecordId> list() throws DynECTExceptions.JobStillRunningException;

    @Named(value="GetRecord")
    @GET
    @Path(value="/AllRecord/{zone}/{fqdn}")
    @ResponseParser(value=ToRecordIds.class)
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public FluentIterable<RecordId> listByFQDN(@PathParam(value="fqdn") String var1) throws DynECTExceptions.JobStillRunningException;

    @Named(value="GetRecord")
    @GET
    @Path(value="/{type}Record/{zone}/{fqdn}")
    @ResponseParser(value=ToRecordIds.class)
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public FluentIterable<RecordId> listByFQDNAndType(@PathParam(value="fqdn") String var1, @PathParam(value="type") String var2) throws DynECTExceptions.JobStillRunningException;

    @Named(value="CreateRecord")
    @POST
    @Path(value="/{type}Record/{zone}/{fqdn}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Job scheduleCreate(@BinderParam(value=CreateRecordBinder.class) CreateRecord<?> var1) throws DynECTExceptions.JobStillRunningException;

    @Nullable
    @Named(value="DeleteRecord")
    @DELETE
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"application/json"})
    public Job scheduleDelete(@BinderParam(value=RecordIdBinder.class) RecordId var1) throws DynECTExceptions.JobStillRunningException;

    @Named(value="GetRecord")
    @GET
    @SelectJson(value={"data"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Record<? extends Map<String, Object>> get(@BinderParam(value=RecordIdBinder.class) RecordId var1) throws DynECTExceptions.JobStillRunningException;

    @Named(value="GetAAAARecord")
    @GET
    @Path(value="/AAAARecord/{zone}/{fqdn}/{id}")
    @SelectJson(value={"data"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Record<AAAAData> getAAAA(@PathParam(value="fqdn") String var1, @PathParam(value="id") long var2) throws DynECTExceptions.JobStillRunningException;

    @Named(value="GetARecord")
    @GET
    @Path(value="/ARecord/{zone}/{fqdn}/{id}")
    @SelectJson(value={"data"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Record<AData> getA(@PathParam(value="fqdn") String var1, @PathParam(value="id") long var2) throws DynECTExceptions.JobStillRunningException;

    @Named(value="GetCNAMERecord")
    @GET
    @Path(value="/CNAMERecord/{zone}/{fqdn}/{id}")
    @SelectJson(value={"data"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Record<CNAMEData> getCNAME(@PathParam(value="fqdn") String var1, @PathParam(value="id") long var2) throws DynECTExceptions.JobStillRunningException;

    @Named(value="GetMXRecord")
    @GET
    @Path(value="/MXRecord/{zone}/{fqdn}/{id}")
    @SelectJson(value={"data"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Record<MXData> getMX(@PathParam(value="fqdn") String var1, @PathParam(value="id") long var2) throws DynECTExceptions.JobStillRunningException;

    @Named(value="GetNSRecord")
    @GET
    @Path(value="/NSRecord/{zone}/{fqdn}/{id}")
    @SelectJson(value={"data"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Record<NSData> getNS(@PathParam(value="fqdn") String var1, @PathParam(value="id") long var2) throws DynECTExceptions.JobStillRunningException;

    @Named(value="GetPTRRecord")
    @GET
    @Path(value="/PTRRecord/{zone}/{fqdn}/{id}")
    @SelectJson(value={"data"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Record<PTRData> getPTR(@PathParam(value="fqdn") String var1, @PathParam(value="id") long var2) throws DynECTExceptions.JobStillRunningException;

    @Named(value="GetSOARecord")
    @GET
    @Path(value="/SOARecord/{zone}/{fqdn}/{id}")
    @SelectJson(value={"data"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public SOARecord getSOA(@PathParam(value="fqdn") String var1, @PathParam(value="id") long var2) throws DynECTExceptions.JobStillRunningException;

    @Named(value="GetSPFRecord")
    @GET
    @Path(value="/SPFRecord/{zone}/{fqdn}/{id}")
    @SelectJson(value={"data"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Record<SPFData> getSPF(@PathParam(value="fqdn") String var1, @PathParam(value="id") long var2) throws DynECTExceptions.JobStillRunningException;

    @Named(value="GetSRVRecord")
    @GET
    @Path(value="/SRVRecord/{zone}/{fqdn}/{id}")
    @SelectJson(value={"data"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Record<SRVData> getSRV(@PathParam(value="fqdn") String var1, @PathParam(value="id") long var2) throws DynECTExceptions.JobStillRunningException;

    @Named(value="GetSSHFPRecord")
    @GET
    @Path(value="/SSHFPRecord/{zone}/{fqdn}/{id}")
    @SelectJson(value={"data"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Record<SSHFPData> getSSHFP(@PathParam(value="fqdn") String var1, @PathParam(value="id") long var2) throws DynECTExceptions.JobStillRunningException;

    @Named(value="GetTXTRecord")
    @GET
    @Path(value="/TXTRecord/{zone}/{fqdn}/{id}")
    @SelectJson(value={"data"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Record<TXTData> getTXT(@PathParam(value="fqdn") String var1, @PathParam(value="id") long var2) throws DynECTExceptions.JobStillRunningException;
}

