/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.options;

import com.google.common.base.Preconditions;
import java.util.Date;
import org.jclouds.gogrid.domain.JobState;
import org.jclouds.gogrid.domain.ObjectType;
import org.jclouds.http.options.BaseHttpRequestOptions;

public class GetJobListOptions
extends BaseHttpRequestOptions {
    public static final GetJobListOptions NONE = new GetJobListOptions();

    public GetJobListOptions maxItemsNumber(Integer maxNumber) {
        Preconditions.checkState((!this.queryParameters.containsKey((Object)"num_items") ? 1 : 0) != 0, (Object)"Can't have duplicate parameter of max returned items");
        this.queryParameters.put((Object)"num_items", (Object)maxNumber.toString());
        return this;
    }

    public GetJobListOptions withStartDate(Date startDate) {
        Preconditions.checkState((!this.queryParameters.containsKey((Object)"startdate") ? 1 : 0) != 0, (Object)"Can't have duplicate start date for filtering");
        this.queryParameters.put((Object)"startdate", (Object)String.valueOf(startDate.getTime()));
        return this;
    }

    public GetJobListOptions withEndDate(Date endDate) {
        Preconditions.checkState((!this.queryParameters.containsKey((Object)"enddate") ? 1 : 0) != 0, (Object)"Can't have duplicate end date for filtering");
        this.queryParameters.put((Object)"enddate", (Object)String.valueOf(endDate.getTime()));
        return this;
    }

    public GetJobListOptions withOwner(String owner) {
        Preconditions.checkState((!this.queryParameters.containsKey((Object)"owner") ? 1 : 0) != 0, (Object)"Can't have duplicate owner name for filtering");
        this.queryParameters.put((Object)"owner", (Object)owner);
        return this;
    }

    public GetJobListOptions onlyForState(JobState jobState) {
        Preconditions.checkState((!this.queryParameters.containsKey((Object)"job.state") ? 1 : 0) != 0, (Object)"Can't have duplicate job state for filtering");
        this.queryParameters.put((Object)"job.state", (Object)jobState.toString());
        return this;
    }

    public GetJobListOptions onlyForObjectType(ObjectType objectType) {
        Preconditions.checkState((!this.queryParameters.containsKey((Object)"job.objecttype") ? 1 : 0) != 0, (Object)"Can't have duplicate object type for filtering");
        this.queryParameters.put((Object)"job.objecttype", (Object)objectType.toString());
        return this;
    }

    public GetJobListOptions onlyForObjectName(String objectName) {
        Preconditions.checkState((!this.queryParameters.containsKey((Object)"object") ? 1 : 0) != 0, (Object)"Can't have duplicate object name for filtering");
        this.queryParameters.put((Object)"object", (Object)objectName);
        return this;
    }

    public GetJobListOptions latestJobForObjectByName(String serverName) {
        return this.maxItemsNumber(1).onlyForObjectName(serverName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GetJobListOptions options = (GetJobListOptions)((Object)o);
        return this.buildQueryParameters().equals((Object)options.buildQueryParameters());
    }

    public static class Builder {
        public static GetJobListOptions maxItems(int maxNumber) {
            return new GetJobListOptions().maxItemsNumber(maxNumber);
        }

        public static GetJobListOptions startDate(Date startDate) {
            return new GetJobListOptions().withStartDate(startDate);
        }

        public static GetJobListOptions latestJobForObjectByName(String serverName) {
            return new GetJobListOptions().latestJobForObjectByName(serverName);
        }
    }
}

