/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.features;

import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Produces;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.profitbricks.binder.datacenter.CreateDataCenterRequestBinder;
import org.jclouds.profitbricks.binder.datacenter.UpdateDataCenterRequestBinder;
import org.jclouds.profitbricks.domain.DataCenter;
import org.jclouds.profitbricks.domain.ProvisioningState;
import org.jclouds.profitbricks.http.filters.ProfitBricksSoapMessageEnvelope;
import org.jclouds.profitbricks.http.parser.datacenter.DataCenterInfoResponseHandler;
import org.jclouds.profitbricks.http.parser.datacenter.DataCenterListResponseHandler;
import org.jclouds.profitbricks.http.parser.state.GetProvisioningStateResponseHandler;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.XMLResponseParser;

@RequestFilters(value={BasicAuthentication.class, ProfitBricksSoapMessageEnvelope.class})
@Consumes(value={"text/xml"})
@Produces(value={"text/xml"})
public interface DataCenterApi {
    @POST
    @Named(value="datacenter:getall")
    @Payload(value="<ws:getAllDataCenters/>")
    @XMLResponseParser(value=DataCenterListResponseHandler.class)
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<DataCenter> getAllDataCenters();

    @POST
    @Named(value="datacenter:get")
    @Payload(value="<ws:getDataCenter><dataCenterId>{id}</dataCenterId></ws:getDataCenter>")
    @XMLResponseParser(value=DataCenterInfoResponseHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public DataCenter getDataCenter(@PayloadParam(value="id") String var1);

    @POST
    @Named(value="datacenter:getstate")
    @Payload(value="<ws:getDataCenterState><dataCenterId>{id}</dataCenterId></ws:getDataCenterState>")
    @XMLResponseParser(value=GetProvisioningStateResponseHandler.class)
    public ProvisioningState getDataCenterState(@PayloadParam(value="id") String var1);

    @POST
    @Named(value="datacenter:create")
    @MapBinder(value=CreateDataCenterRequestBinder.class)
    @XMLResponseParser(value=DataCenterInfoResponseHandler.class)
    public DataCenter createDataCenter(@PayloadParam(value="dataCenter") DataCenter.Request.CreatePayload var1);

    @POST
    @Named(value="datacenter:update")
    @MapBinder(value=UpdateDataCenterRequestBinder.class)
    @XMLResponseParser(value=DataCenterInfoResponseHandler.class)
    public DataCenter updateDataCenter(@PayloadParam(value="dataCenter") DataCenter.Request.UpdatePayload var1);

    @POST
    @Named(value="datacenter:clear")
    @Payload(value="<ws:clearDataCenter><dataCenterId>{id}</dataCenterId></ws:clearDataCenter>")
    @XMLResponseParser(value=DataCenterInfoResponseHandler.class)
    public DataCenter clearDataCenter(@PayloadParam(value="id") String var1);

    @POST
    @Named(value="datacenter:delete")
    @Payload(value="<ws:deleteDataCenter><dataCenterId>{id}</dataCenterId></ws:deleteDataCenter>")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deleteDataCenter(@PayloadParam(value="id") String var1);
}

