/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.features;

import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Produces;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.profitbricks.binder.firewall.AddFirewallRuleToNicRequestBinder;
import org.jclouds.profitbricks.binder.firewall.FirewallBinder;
import org.jclouds.profitbricks.domain.Firewall;
import org.jclouds.profitbricks.http.filters.ProfitBricksSoapMessageEnvelope;
import org.jclouds.profitbricks.http.parser.firewall.FirewallListResponseHandler;
import org.jclouds.profitbricks.http.parser.firewall.FirewallResponseHandler;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.XMLResponseParser;

@RequestFilters(value={BasicAuthentication.class, ProfitBricksSoapMessageEnvelope.class})
@Consumes(value={"text/xml"})
@Produces(value={"text/xml"})
public interface FirewallApi {
    @POST
    @Named(value="firewall:get")
    @Payload(value="<ws:getFirewall><firewallId>{id}</firewallId></ws:getFirewall>")
    @XMLResponseParser(value=FirewallResponseHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Firewall getFirewall(@PayloadParam(value="id") String var1);

    @POST
    @Named(value="firewall:getall")
    @Payload(value="<ws:getAllFirewalls/>")
    @XMLResponseParser(value=FirewallListResponseHandler.class)
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<Firewall> getAllFirewalls();

    @POST
    @Named(value="firewall:addrule")
    @MapBinder(value=AddFirewallRuleToNicRequestBinder.class)
    @XMLResponseParser(value=FirewallResponseHandler.class)
    public Firewall addFirewallRuleToNic(@PayloadParam(value="firewall") Firewall.Request.AddRulePayload var1);

    @POST
    @Named(value="firewall:removerule")
    @MapBinder(value=FirewallBinder.RemoveFirewallRuleRequestBinder.class)
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean removeFirewallRules(@PayloadParam(value="ids") List<String> var1);

    @POST
    @Named(value="firewall:activate")
    @MapBinder(value=FirewallBinder.ActivateFirewallRequestBinder.class)
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean activateFirewall(@PayloadParam(value="ids") List<String> var1);

    @POST
    @Named(value="firewall:activate")
    @MapBinder(value=FirewallBinder.DeactivateFirewallRequestBinder.class)
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deactivateFirewall(@PayloadParam(value="ids") List<String> var1);

    @POST
    @Named(value="firewall:activate")
    @MapBinder(value=FirewallBinder.DeleteFirewallRequestBinder.class)
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deleteFirewall(@PayloadParam(value="ids") List<String> var1);
}

