/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.features;

import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Produces;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.profitbricks.binder.snapshot.CreateSnapshotRequestBinder;
import org.jclouds.profitbricks.binder.snapshot.RollbackSnapshotRequestBinder;
import org.jclouds.profitbricks.binder.snapshot.UpdateSnapshotRequestBinder;
import org.jclouds.profitbricks.domain.Snapshot;
import org.jclouds.profitbricks.http.filters.ProfitBricksSoapMessageEnvelope;
import org.jclouds.profitbricks.http.parser.RequestIdOnlyResponseHandler;
import org.jclouds.profitbricks.http.parser.snapshot.SnapshotListResponseHandler;
import org.jclouds.profitbricks.http.parser.snapshot.SnapshotResponseHandler;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.XMLResponseParser;

@RequestFilters(value={BasicAuthentication.class, ProfitBricksSoapMessageEnvelope.class})
@Consumes(value={"text/xml"})
@Produces(value={"text/xml"})
public interface SnapshotApi {
    @POST
    @Named(value="snapshot:getall")
    @Payload(value="<ws:getAllSnapshots/>")
    @XMLResponseParser(value=SnapshotListResponseHandler.class)
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<Snapshot> getAllSnapshots();

    @POST
    @Named(value="snapshot:get")
    @Payload(value="<ws:getSnapshot><snapshotId>{snapshotId}</snapshotId></ws:getSnapshot>")
    @XMLResponseParser(value=SnapshotResponseHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Snapshot getSnapshot(@PayloadParam(value="snapshotId") String var1);

    @POST
    @Named(value="snapshot:create")
    @MapBinder(value=CreateSnapshotRequestBinder.class)
    @XMLResponseParser(value=SnapshotResponseHandler.class)
    public Snapshot createSnapshot(@PayloadParam(value="snapshot") Snapshot.Request.CreatePayload var1);

    @POST
    @Named(value="snapshot:update")
    @MapBinder(value=UpdateSnapshotRequestBinder.class)
    @XMLResponseParser(value=RequestIdOnlyResponseHandler.class)
    public String updateSnapshot(@PayloadParam(value="snapshot") Snapshot.Request.UpdatePayload var1);

    @POST
    @Named(value="snapshot:delete")
    @Payload(value="<ws:deleteSnapshot><snapshotId>{id}</snapshotId></ws:deleteSnapshot>")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deleteSnapshot(@PayloadParam(value="id") String var1);

    @POST
    @Named(value="snapshot:rollback")
    @MapBinder(value=RollbackSnapshotRequestBinder.class)
    @XMLResponseParser(value=RequestIdOnlyResponseHandler.class)
    public String rollbackSnapshot(@PayloadParam(value="snapshot") Snapshot.Request.RollbackPayload var1);
}

