/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.adapters;

import com.hp.hpl.jena.rdf.arp.JenaReader;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;

public class RDFReaderRIOT_ARP
implements RDFReader {
    static FileManager fileMgr = new FileManager();
    JenaReader reader = new JenaReader();

    public void read(Model model, Reader r, String base) {
        this.reader.read(model, r, base);
    }

    public void read(Model model, InputStream r, String base) {
        this.reader.read(model, r, base);
    }

    public void read(Model model, String url) {
        String base = RDFReaderRIOT_ARP.chooseBaseURI(url);
        this.reader.read(model, base);
    }

    private static String chooseBaseURI(String baseURI) {
        String scheme = FileUtils.getScheme((String)baseURI);
        if (scheme != null) {
            if (scheme.equals("file") && !baseURI.startsWith("file:///")) {
                try {
                    String tmp = baseURI.substring("file:".length());
                    File f = new File(tmp);
                    baseURI = "file:///" + f.getCanonicalPath();
                    baseURI = baseURI.replace('\\', '/');
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return baseURI;
        }
        if (baseURI.startsWith("/")) {
            return "file://" + baseURI;
        }
        return "file:" + baseURI;
    }

    public Object setProperty(String propName, Object propValue) {
        return this.reader.setProperty(propName, propValue);
    }

    public RDFErrorHandler setErrorHandler(RDFErrorHandler errHandler) {
        return this.reader.setErrorHandler(errHandler);
    }

    static {
        fileMgr.addLocatorFile();
        fileMgr.addLocatorURL();
    }
}

