/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.optimize;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVars;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.op.Op1;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpConditional;
import com.hp.hpl.jena.sparql.algebra.op.OpExtend;
import com.hp.hpl.jena.sparql.algebra.op.OpExtendAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpSequence;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.util.VarUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.jena.atlas.lib.CollectionUtils;
import org.apache.jena.atlas.lib.DS;

public class TransformFilterPlacement
extends TransformCopy {
    static final ExprList emptyList = new ExprList();
    static final Placement noChangePlacement = null;
    private final boolean includeBGPs;
    static boolean pushRightAsWellAsLeft = true;

    private static Placement result(Op op, ExprList remaining) {
        if (op == null) {
            return null;
        }
        return new Placement(op, remaining);
    }

    private Placement resultNoChange(Op original) {
        return noChangePlacement;
    }

    private boolean isNoChange(Placement placement) {
        return placement == noChangePlacement;
    }

    public static Op transform(ExprList exprs, BasicPattern bgp) {
        Op op;
        Placement placement = TransformFilterPlacement.placeBGP(exprs, bgp);
        Op op2 = op = placement == null ? new OpBGP(bgp) : placement.op;
        if (placement != null) {
            op = TransformFilterPlacement.buildFilter(placement.unplaced, op);
        }
        return op;
    }

    public static Op transform(ExprList exprs, Node graphNode, BasicPattern bgp) {
        Op op;
        Placement placement = TransformFilterPlacement.placeQuadPattern(exprs, graphNode, bgp);
        Op op2 = op = placement == null ? new OpQuadPattern(graphNode, bgp) : placement.op;
        if (placement != null) {
            op = TransformFilterPlacement.buildFilter(placement.unplaced, op);
        }
        return op;
    }

    public TransformFilterPlacement() {
        this(true);
    }

    public TransformFilterPlacement(boolean includeBGPs) {
        this.includeBGPs = includeBGPs;
    }

    @Override
    public Op transform(OpFilter opFilter, Op x) {
        ExprList exprs = opFilter.getExprs();
        Placement placement = this.transform(exprs, x);
        if (placement == null || placement.op == x) {
            return super.transform(opFilter, x);
        }
        Op op = TransformFilterPlacement.buildFilter(placement);
        return op;
    }

    private Op transformOp(ExprList exprs, Op x) {
        Placement placement = this.transform(exprs, x);
        Op op = TransformFilterPlacement.buildFilter(placement);
        return op;
    }

    private Placement transform(ExprList exprs, Op input) {
        Placement placement = null;
        if (input instanceof OpBGP) {
            if (this.includeBGPs) {
                placement = TransformFilterPlacement.placeBGP(exprs, (OpBGP)input);
            }
        } else if (input instanceof OpQuadPattern) {
            if (this.includeBGPs) {
                placement = this.placeQuadPattern(exprs, (OpQuadPattern)input);
            }
        } else if (input instanceof OpSequence) {
            placement = this.placeSequence(exprs, (OpSequence)input);
        } else if (input instanceof OpJoin) {
            placement = this.placeJoin(exprs, (OpJoin)input);
        } else if (input instanceof OpConditional) {
            placement = this.placeConditional(exprs, (OpConditional)input);
        } else if (input instanceof OpLeftJoin) {
            placement = this.placeLeftJoin(exprs, (OpLeftJoin)input);
        } else if (input instanceof OpFilter) {
            placement = this.placeFilter(exprs, (OpFilter)input);
        } else if (input instanceof OpUnion) {
            placement = this.placeUnion(exprs, (OpUnion)input);
        } else if (input instanceof OpExtend) {
            placement = this.placeExtend(exprs, (OpExtend)input);
        } else if (input instanceof OpAssign) {
            placement = this.placeAssign(exprs, (OpAssign)input);
        } else if (input instanceof OpProject) {
            placement = this.placeProject(exprs, (OpProject)input);
        }
        return placement;
    }

    private Placement x_placeNoOp(ExprList exprs, Op op) {
        return TransformFilterPlacement.result(op, exprs);
    }

    private Placement placeFilter(ExprList exprs, OpFilter input) {
        Placement p = this.transform(exprs, input.getSubOp());
        if (p == null) {
            p = new Placement(input.getSubOp(), exprs);
        }
        p.unplaced.addAll(input.getExprs());
        return p;
    }

    private static Placement placeBGP(ExprList exprs, OpBGP x) {
        return TransformFilterPlacement.placeBGP(exprs, x.getPattern());
    }

    private static Placement placeBGP(ExprList exprsIn, BasicPattern pattern) {
        ExprList exprs = new ExprList(exprsIn);
        Set<Var> patternVarsScope = DS.set();
        Op op = null;
        for (Triple triple : pattern) {
            OpBGP opBGP = TransformFilterPlacement.getBGP(op = TransformFilterPlacement.insertAnyFilter(exprs, patternVarsScope, op));
            if (opBGP == null) {
                opBGP = new OpBGP();
                op = OpSequence.create(op, opBGP);
            }
            opBGP.getPattern().add(triple);
            VarUtils.addVarsFromTriple(patternVarsScope, triple);
        }
        op = TransformFilterPlacement.insertAnyFilter(exprs, patternVarsScope, op);
        return TransformFilterPlacement.result(op, exprs);
    }

    private static OpBGP getBGP(Op op) {
        Op opTop;
        OpSequence opSeq;
        List<Op> x;
        if (op instanceof OpBGP) {
            return (OpBGP)op;
        }
        if (op instanceof OpSequence && (x = (opSeq = (OpSequence)op).getElements()).size() > 0 && (opTop = x.get(x.size() - 1)) instanceof OpBGP) {
            return (OpBGP)opTop;
        }
        return null;
    }

    private Placement placeQuadPattern(ExprList exprs, OpQuadPattern pattern) {
        return TransformFilterPlacement.placeQuadPattern(exprs, pattern.getGraphNode(), pattern.getBasicPattern());
    }

    private static Placement placeQuadPattern(ExprList exprsIn, Node graphNode, BasicPattern pattern) {
        ExprList exprs = new ExprList(exprsIn);
        Set<Var> patternVarsScope = DS.set();
        if (Var.isVar(graphNode)) {
            VarUtils.addVar(patternVarsScope, (Node)Var.alloc(graphNode));
        }
        Op op = null;
        for (Triple triple : pattern) {
            OpQuadPattern opQuad = TransformFilterPlacement.getQuads(op = TransformFilterPlacement.insertAnyFilter(exprs, patternVarsScope, op));
            if (opQuad == null) {
                opQuad = new OpQuadPattern(graphNode, new BasicPattern());
                op = OpSequence.create(op, opQuad);
            }
            opQuad.getBasicPattern().add(triple);
            VarUtils.addVarsFromTriple(patternVarsScope, triple);
        }
        op = TransformFilterPlacement.insertAnyFilter(exprs, patternVarsScope, op);
        return TransformFilterPlacement.result(op, exprs);
    }

    private static OpQuadPattern getQuads(Op op) {
        Op opTop;
        OpSequence opSeq;
        List<Op> x;
        if (op instanceof OpQuadPattern) {
            return (OpQuadPattern)op;
        }
        if (op instanceof OpSequence && (x = (opSeq = (OpSequence)op).getElements()).size() > 0 && (opTop = x.get(x.size() - 1)) instanceof OpQuadPattern) {
            return (OpQuadPattern)opTop;
        }
        return null;
    }

    private Placement placeSequence(ExprList exprsIn, OpSequence opSequence) {
        ExprList exprs = new ExprList(exprsIn);
        Set<Var> varScope = DS.set();
        List<Op> ops = opSequence.getElements();
        Op op = null;
        for (int i = 0; i < ops.size(); ++i) {
            op = TransformFilterPlacement.insertAnyFilter(exprs, varScope, op);
            Op seqElt = ops.get(i);
            if (i != ops.size() - 1) {
                Placement p = this.transform(exprs, seqElt);
                if (p != null) {
                    exprs = p.unplaced;
                    seqElt = p.op;
                }
                varScope.addAll(this.fixedVars(seqElt));
            }
            op = OpSequence.create(op, seqElt);
        }
        return TransformFilterPlacement.result(op, exprs);
    }

    private Placement placeJoin(ExprList exprs, OpJoin opJoin) {
        Op left = opJoin.getLeft();
        Op right = opJoin.getRight();
        Set<Var> leftVars = this.fixedVars(left);
        Set<Var> rightVars = this.fixedVars(right);
        ExprList unpushed = new ExprList();
        ExprList pushLeft = new ExprList();
        ExprList pushRight = new ExprList();
        for (Expr expr : exprs) {
            Set<Var> vars = expr.getVarsMentioned();
            boolean pushed = false;
            if (leftVars.containsAll(vars)) {
                pushLeft.add(expr);
                pushed = true;
            }
            if (pushed && !pushRightAsWellAsLeft) continue;
            if (rightVars.containsAll(vars)) {
                pushRight.add(expr);
                pushed = true;
            }
            if (pushed) continue;
            unpushed.add(expr);
        }
        if (pushLeft.isEmpty() && pushRight.isEmpty()) {
            return null;
        }
        Op opLeftNew = left;
        if (!pushLeft.isEmpty()) {
            opLeftNew = this.transformOp(pushLeft, opLeftNew);
        }
        Op opRightNew = right;
        if (!pushRight.isEmpty()) {
            opRightNew = this.transformOp(pushRight, opRightNew);
        }
        Op op = OpJoin.create(opLeftNew, opRightNew);
        return TransformFilterPlacement.result(op, unpushed);
    }

    private Placement placeConditional(ExprList exprs, OpConditional opConditional) {
        Op left = opConditional.getLeft();
        Op right = opConditional.getRight();
        Placement nLeft = this.transform(exprs, left);
        if (nLeft == null) {
            return TransformFilterPlacement.result(opConditional, exprs);
        }
        OpConditional op = new OpConditional(nLeft.op, right);
        return TransformFilterPlacement.result(op, nLeft.unplaced);
    }

    private Placement placeLeftJoin(ExprList exprs, OpLeftJoin opLeftJoin) {
        Op left = opLeftJoin.getLeft();
        Op right = opLeftJoin.getRight();
        Placement nLeft = this.transform(exprs, left);
        if (nLeft == null) {
            return TransformFilterPlacement.result(opLeftJoin, exprs);
        }
        Op op = OpLeftJoin.create(nLeft.op, right, opLeftJoin.getExprs());
        return TransformFilterPlacement.result(op, nLeft.unplaced);
    }

    private Placement placeUnion(ExprList exprs, OpUnion input) {
        Op left = input.getLeft();
        Placement pLeft = this.transform(exprs, left);
        left = TransformFilterPlacement.buildFilter(pLeft);
        Op right = input.getRight();
        Placement pRight = this.transform(exprs, right);
        right = TransformFilterPlacement.buildFilter(pRight);
        Op op2 = OpUnion.create(left, right);
        return TransformFilterPlacement.result(op2, emptyList);
    }

    private Placement placeExtend(ExprList exprs, OpExtend input) {
        return this.processExtendAssign(exprs, input);
    }

    private Placement placeAssign(ExprList exprs, OpAssign input) {
        return this.processExtendAssign(exprs, input);
    }

    private Placement processExtendAssign(ExprList exprs, OpExtendAssign input) {
        List<Var> vars1 = input.getVarExprList().getVars();
        ExprList pushed = new ExprList();
        ExprList unpushed = new ExprList();
        for (Expr expr : exprs) {
            Set<Var> exprVars = expr.getVarsMentioned();
            if (TransformFilterPlacement.disjoint(vars1, exprVars)) {
                pushed.add(expr);
                continue;
            }
            unpushed.add(expr);
        }
        if (pushed.isEmpty()) {
            return this.resultNoChange(input);
        }
        Op opSub = input.getSubOp();
        Placement p = this.transform(pushed, opSub);
        if (p == null) {
            return null;
        }
        if (!p.unplaced.isEmpty()) {
            unpushed.addAll(p.unplaced);
        }
        Op1 op1 = input.copy(p.op);
        return TransformFilterPlacement.result(op1, unpushed);
    }

    private Placement placeProject(ExprList exprs, OpProject input) {
        Op op1;
        List<Var> varsProject = input.getVars();
        ExprList pushed = new ExprList();
        ExprList unpushed = new ExprList();
        for (Expr expr : exprs) {
            Set<Var> exprVars = expr.getVarsMentioned();
            if (varsProject.containsAll(exprVars)) {
                pushed.add(expr);
                continue;
            }
            unpushed.add(expr);
        }
        if (pushed.isEmpty()) {
            return this.resultNoChange(input);
        }
        Op opSub = input.getSubOp();
        Placement p = this.transform(pushed, opSub);
        if (p == null) {
            op1 = OpFilter.filter(pushed, opSub);
            Op1 op2 = input.copy(op1);
            return TransformFilterPlacement.result(op2, unpushed);
        }
        op1 = OpFilter.filter(p.unplaced, p.op);
        Op1 op2 = input.copy(op1);
        return TransformFilterPlacement.result(op2, unpushed);
    }

    private Set<Var> fixedVars(Op op) {
        return OpVars.fixedVars(op);
    }

    private static Op insertAnyFilter(ExprList exprs, Set<Var> patternVarsScope, Op op) {
        Iterator<Expr> iter = exprs.iterator();
        while (iter.hasNext()) {
            Expr expr = iter.next();
            Set<Var> exprVars = expr.getVarsMentioned();
            if (!patternVarsScope.containsAll(exprVars)) continue;
            if (op == null) {
                op = OpTable.unit();
            }
            op = OpFilter.filter(expr, op);
            iter.remove();
        }
        return op;
    }

    private static <T> boolean disjoint(Collection<T> collection, Collection<T> possibleElts) {
        return CollectionUtils.disjoint(collection, possibleElts);
    }

    private static Op buildFilter(Placement placement) {
        if (placement == null) {
            return null;
        }
        if (placement.unplaced.isEmpty()) {
            return placement.op;
        }
        return TransformFilterPlacement.buildFilter(placement.unplaced, placement.op);
    }

    private static Op buildFilter(ExprList exprs, Op op) {
        if (exprs == null || exprs.isEmpty()) {
            return op;
        }
        Iterator<Expr> iter = exprs.iterator();
        while (iter.hasNext()) {
            Expr expr = iter.next();
            if (op == null) {
                op = OpTable.unit();
            }
            op = OpFilter.filter(expr, op);
            iter.remove();
        }
        return op;
    }

    static class Placement {
        final Op op;
        final ExprList unplaced;

        Placement(Op op, ExprList remaining) {
            this.op = op;
            this.unplaced = remaining;
        }
    }
}

