/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterTracked;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIteratorBase;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIteratorCopy;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import org.apache.jena.atlas.io.IndentedWriter;

public abstract class QueryIter
extends QueryIteratorBase {
    static volatile int iteratorCounter = 0;
    private int iteratorNumber = iteratorCounter++;
    private ExecutionContext tracker;

    public QueryIter(ExecutionContext execCxt) {
        this.tracker = execCxt;
        this.register();
    }

    public static QueryIter makeTracked(QueryIterator qIter, ExecutionContext execCxt) {
        if (qIter instanceof QueryIter) {
            return (QueryIter)qIter;
        }
        return new QueryIterTracked(qIter, execCxt);
    }

    public static QueryIter materialize(QueryIterator qIter, ExecutionContext execCxt) {
        return QueryIter.makeTracked(QueryIter.materialize(qIter), execCxt);
    }

    public static QueryIterator materialize(QueryIterator qIter) {
        return new QueryIteratorCopy(qIter);
    }

    @Override
    public final void close() {
        super.close();
        this.deregister();
    }

    public ExecutionContext getExecContext() {
        return this.tracker;
    }

    public int getIteratorNumber() {
        return this.iteratorNumber;
    }

    @Override
    public void output(IndentedWriter out) {
        this.output(out, null);
    }

    @Override
    public void output(IndentedWriter out, SerializationContext sCxt) {
        out.println(this.getIteratorNumber() + "/" + this.debug());
    }

    private void register() {
        if (this.tracker != null) {
            this.tracker.openIterator(this);
        }
    }

    private void deregister() {
        if (this.tracker != null) {
            this.tracker.closedIterator(this);
        }
    }
}

