/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.writers.WriterNode;
import com.hp.hpl.jena.sparql.util.Iso;
import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;

public class BasicPattern
implements Iterable<Triple> {
    private List<Triple> triples;

    public BasicPattern() {
        this(new ArrayList<Triple>());
    }

    public BasicPattern(BasicPattern other) {
        this();
        this.triples.addAll(other.triples);
    }

    private BasicPattern(List<Triple> triples) {
        this.triples = triples;
    }

    public static BasicPattern wrap(List<Triple> triples) {
        return new BasicPattern(triples);
    }

    public void add(Triple t) {
        this.triples.add(t);
    }

    public void addAll(BasicPattern other) {
        this.triples.addAll(other.triples);
    }

    public void add(int i, Triple t) {
        this.triples.add(i, t);
    }

    public Triple get(int i) {
        return this.triples.get(i);
    }

    @Override
    public Iterator<Triple> iterator() {
        return this.triples.listIterator();
    }

    public int size() {
        return this.triples.size();
    }

    public boolean isEmpty() {
        return this.triples.isEmpty();
    }

    public List<Triple> getList() {
        return this.triples;
    }

    public int hashCode() {
        return ((Object)this.triples).hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BasicPattern)) {
            return false;
        }
        BasicPattern bp = (BasicPattern)other;
        return ((Object)this.triples).equals(bp.triples);
    }

    public boolean equiv(BasicPattern other, NodeIsomorphismMap isoMap) {
        if (this.triples.size() != other.triples.size()) {
            return false;
        }
        for (int i = 0; i < this.triples.size(); ++i) {
            Triple t2;
            Triple t1 = this.get(i);
            if (Iso.tripleIso(t1, t2 = other.get(i), isoMap)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        IndentedLineBuffer out = new IndentedLineBuffer();
        SerializationContext sCxt = SSE.sCxt(SSE.defaultPrefixMapWrite);
        boolean first = true;
        for (Triple t : this.triples) {
            if (!first) {
                out.print("\n");
            } else {
                first = false;
            }
            out.print("(");
            WriterNode.outputPlain((IndentedWriter)out, t, sCxt);
            out.print(")");
        }
        out.flush();
        return out.toString();
    }
}

