/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.ResultSetRewindable;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingUtils;
import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;
import com.hp.hpl.jena.sparql.util.NodeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.Transform;

public class ResultSetCompare {
    private static Transform<QuerySolution, Binding> qs2b = new Transform<QuerySolution, Binding>(){

        @Override
        public Binding convert(QuerySolution item) {
            return BindingUtils.asBinding(item);
        }
    };

    public static boolean equalsByValue(ResultSet rs1, ResultSet rs2) {
        if (!ResultSetCompare.compareHeader(rs1, rs2)) {
            return false;
        }
        ResultSetRewindable rs1a = ResultSetFactory.makeRewindable(rs1);
        ResultSetRewindable rs2a = ResultSetFactory.makeRewindable(rs2);
        if (ResultSetCompare.equivalent(ResultSetCompare.convert(rs1a), ResultSetCompare.convert(rs2a), new BNodeIso(NodeUtils.sameValue))) {
            return true;
        }
        rs1a.reset();
        rs2a.reset();
        return ResultSetCompare.isomorphic(rs1, rs2);
    }

    public static boolean equalsByTest(Collection<Binding> b1, Collection<Binding> b2, NodeUtils.EqualityTest match) {
        ArrayList<Binding> rows1 = new ArrayList<Binding>(b1);
        ArrayList<Binding> rows2 = new ArrayList<Binding>(b2);
        return ResultSetCompare.equivalent(rows1, rows2, match);
    }

    public static boolean equalsByTerm(ResultSet rs1, ResultSet rs2) {
        if (!ResultSetCompare.compareHeader(rs1, rs2)) {
            return false;
        }
        ResultSetRewindable rs1a = ResultSetFactory.makeRewindable(rs1);
        ResultSetRewindable rs2a = ResultSetFactory.makeRewindable(rs2);
        if (ResultSetCompare.equivalent(ResultSetCompare.convert(rs1a), ResultSetCompare.convert(rs2a), new BNodeIso(NodeUtils.sameTerm))) {
            return true;
        }
        rs1a.reset();
        rs2a.reset();
        return ResultSetCompare.isomorphic(rs1, rs2);
    }

    public static boolean equalsByValueAndOrder(ResultSet rs1, ResultSet rs2) {
        if (!ResultSetCompare.compareHeader(rs1, rs2)) {
            return false;
        }
        return ResultSetCompare.equivalentByOrder(ResultSetCompare.convert(rs1), ResultSetCompare.convert(rs2), new BNodeIso(NodeUtils.sameValue));
    }

    public static boolean equalsByTermAndOrder(ResultSet rs1, ResultSet rs2) {
        if (!ResultSetCompare.compareHeader(rs1, rs2)) {
            return false;
        }
        return ResultSetCompare.equivalentByOrder(ResultSetCompare.convert(rs1), ResultSetCompare.convert(rs2), new BNodeIso(NodeUtils.sameTerm));
    }

    public static boolean isomorphic(ResultSet rs1, ResultSet rs2) {
        Model m1 = ResultSetFormatter.toModel(rs1);
        Model m2 = ResultSetFormatter.toModel(rs2);
        return m1.isIsomorphicWith(m2);
    }

    public static boolean equal(Binding bind1, Binding bind2, NodeUtils.EqualityTest test) {
        if (bind1 == bind2) {
            return true;
        }
        if (bind1.size() != bind2.size()) {
            return false;
        }
        return ResultSetCompare.containedIn(bind1, bind2, test);
    }

    private static boolean compareHeader(ResultSet rs1, ResultSet rs2) {
        if (rs1 == null && rs2 == null) {
            return true;
        }
        if (rs1 == null) {
            return false;
        }
        if (rs2 == null) {
            return false;
        }
        HashSet<String> names1 = new HashSet<String>(rs1.getResultVars());
        HashSet<String> names2 = new HashSet<String>(rs2.getResultVars());
        return ((Object)names1).equals(names2);
    }

    private static List<Binding> convert(ResultSet rs) {
        return Iter.iter(rs).map(qs2b).toList();
    }

    private static boolean equivalent(Collection<Binding> rows1, Collection<Binding> rows2, NodeUtils.EqualityTest match) {
        if (rows1.size() != rows2.size()) {
            return false;
        }
        for (Binding row1 : rows1) {
            Binding matched = null;
            for (Binding row2 : rows2) {
                if (!ResultSetCompare.equal(row1, row2, match)) continue;
                matched = row2;
                break;
            }
            if (matched == null) {
                return false;
            }
            rows2.remove(matched);
        }
        return true;
    }

    private static boolean equivalentByOrder(List<Binding> rows1, List<Binding> rows2, NodeUtils.EqualityTest match) {
        if (rows1.size() != rows2.size()) {
            return false;
        }
        Iterator<Binding> iter1 = rows1.iterator();
        Iterator<Binding> iter2 = rows2.iterator();
        while (iter1.hasNext()) {
            Binding row2;
            Binding row1 = iter1.next();
            if (ResultSetCompare.equal(row1, row2 = iter2.next(), match)) continue;
            return false;
        }
        return true;
    }

    private static boolean containedIn(Binding bind1, Binding bind2, NodeUtils.EqualityTest test) {
        Iterator<Var> iter1 = bind1.vars();
        for (Var v : Iter.iter(iter1)) {
            Node n1 = bind1.get(v);
            Node n2 = bind2.get(v);
            if (n2 == null) {
                return false;
            }
            if (test.equal(n1, n2)) continue;
            return false;
        }
        return true;
    }

    public static class BNodeIso
    implements NodeUtils.EqualityTest {
        private NodeIsomorphismMap mapping = new NodeIsomorphismMap();
        private NodeUtils.EqualityTest literalTest;

        public BNodeIso(NodeUtils.EqualityTest literalTest) {
            this.literalTest = literalTest;
        }

        @Override
        public boolean equal(Node n1, Node n2) {
            if (n1 == null && n2 == null) {
                return true;
            }
            if (n1 == null) {
                return false;
            }
            if (n2 == null) {
                return false;
            }
            if (n1.isURI() && n2.isURI()) {
                return n1.equals((Object)n2);
            }
            if (n1.isLiteral() && n2.isLiteral()) {
                return this.literalTest.equal(n1, n2);
            }
            if (n1.isBlank() && n2.isBlank()) {
                return this.mapping.makeIsomorphic(n1, n2);
            }
            return false;
        }
    }
}

