/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.resultset;

import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetRewindable;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.ResultBinding;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.resultset.ResultSetException;
import com.hp.hpl.jena.sparql.resultset.ResultSetPeekable;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.iterator.PeekIterator;

public class ResultSetMem
implements ResultSetRewindable,
ResultSetPeekable {
    protected List<Binding> rows = new ArrayList<Binding>();
    protected List<String> varNames = null;
    private int rowNumber = 0;
    private PeekIterator<Binding> iterator = null;
    private Model model = null;

    public ResultSetMem(ResultSetMem imrs2) {
        this(imrs2, false);
    }

    public ResultSetMem(ResultSetMem imrs2, boolean takeCopy) {
        this.varNames = imrs2.varNames;
        if (takeCopy) {
            this.rows.addAll(imrs2.rows);
        } else {
            this.rows = imrs2.rows;
        }
        this.reset();
    }

    public ResultSetMem(ResultSet qr) {
        this.model = qr.getResourceModel();
        if (qr instanceof ResultSetMem) {
            ResultSetMem qrm = (ResultSetMem)qr;
            this.rows = qrm.rows;
            this.varNames = qrm.varNames;
        } else {
            this.varNames = qr.getResultVars();
            while (qr.hasNext()) {
                Binding rb = qr.nextBinding();
                this.rows.add(rb);
            }
        }
        this.reset();
    }

    public ResultSetMem(ResultSet ... sets) {
        this.varNames = sets[0].getResultVars();
        for (ResultSet rs : sets) {
            if (!((Object)this.varNames).equals(rs.getResultVars())) {
                throw new ResultSetException("ResultSet must have the same variables.");
            }
            if (rs instanceof ResultSetMem) {
                this.rows.addAll(((ResultSetMem)rs).rows);
                continue;
            }
            while (rs.hasNext()) {
                this.rows.add(rs.nextBinding());
            }
        }
        this.reset();
    }

    public ResultSetMem() {
        this.varNames = new ArrayList<String>();
        this.reset();
    }

    @Override
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(Utils.className(this) + ": Attempt to remove an element");
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public QuerySolution nextSolution() {
        return new ResultBinding(this.model, this.nextBinding());
    }

    @Override
    public Binding nextBinding() {
        ++this.rowNumber;
        return this.iterator.next();
    }

    @Override
    public QuerySolution next() {
        return this.nextSolution();
    }

    public void rewind() {
        this.reset();
    }

    @Override
    public void reset() {
        this.iterator = new PeekIterator<Binding>(this.rows.iterator());
        this.rowNumber = 0;
    }

    @Override
    public int getRowNumber() {
        return this.rowNumber;
    }

    @Override
    public Model getResourceModel() {
        return this.model;
    }

    @Override
    public int size() {
        return this.rows.size();
    }

    @Override
    public List<String> getResultVars() {
        return this.varNames;
    }

    @Override
    public QuerySolution peek() {
        return new ResultBinding(this.model, this.peekBinding());
    }

    @Override
    public Binding peekBinding() {
        return this.iterator.element();
    }
}

