/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util.graph;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jena.atlas.logging.Log;

public class GraphContainerUtils {
    private static final Node RDFtype = RDF.type.asNode();
    private static final Node BAG = RDF.Bag.asNode();
    private static final Node ALT = RDF.Alt.asNode();
    private static final Node SEQ = RDF.Seq.asNode();
    private static final String membershipPattern$ = RDF.getURI() + "_(\\d+)";
    private static final Pattern membershipPattern = Pattern.compile(membershipPattern$);
    private static final int NOT_FOUND = -9999;
    private static Node RDFSmember = RDFS.member.asNode();
    private static Filter<Triple> filterRDFSmember = new Filter<Triple>(){

        public boolean accept(Triple triple) {
            Node p = triple.getPredicate();
            if (!triple.getPredicate().isURI()) {
                return false;
            }
            if (RDFSmember.equals((Object)p)) {
                return true;
            }
            String u = triple.getPredicate().getURI();
            return membershipPattern.matcher(u).matches();
        }
    };
    static ContainerOrder order = new ContainerOrder();

    public static Collection<Node> containerMembers(Graph graph, Node container2) {
        return GraphContainerUtils.containerMembers(graph, container2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Node> containerMembers(Graph graph, Node container2, Node containerType) {
        if (!GraphContainerUtils.isContainer(graph, container2, containerType)) {
            return null;
        }
        ExtendedIterator iter = graph.find(container2, Node.ANY, Node.ANY);
        TreeMap<Integer, Node> triples = new TreeMap<Integer, Node>(order);
        try {
            while (iter.hasNext()) {
                Triple t = (Triple)iter.next();
                int index = GraphContainerUtils.getIndex(t);
                if (index == -9999) continue;
                triples.put(new Integer(index), t.getObject());
            }
        }
        finally {
            iter.close();
        }
        return triples.values();
    }

    public static boolean isContainerMember(Graph graph, Node container2, Node containerType, Node member) {
        return GraphContainerUtils.countContainerMember(graph, container2, containerType, member, true) != 0;
    }

    public static int countContainerMember(Graph graph, Node container2, Node containerType, Node member) {
        return GraphContainerUtils.countContainerMember(graph, container2, containerType, member, false);
    }

    public static Iterator<Triple> rdfsMember(Graph graph, Node s, Node o) {
        ExtendedIterator iter = graph.find(s, Node.ANY, o);
        return iter.filterKeep(filterRDFSmember);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int countContainerMember(Graph graph, Node container2, Node containerType, Node member, boolean stopEarly) {
        if (graph == null) {
            Log.warn(GraphContainerUtils.class, "containerMember called with null graph");
            return 0;
        }
        if (container2 == null) {
            Log.warn(GraphContainerUtils.class, "containerMember called with null list");
            return 0;
        }
        if (member == null) {
            Log.warn(GraphContainerUtils.class, "containerMember called with null member");
            return 0;
        }
        if (!GraphContainerUtils.isContainer(graph, container2, containerType)) {
            return 0;
        }
        int count = 0;
        ExtendedIterator iter = graph.find(container2, Node.ANY, member);
        try {
            block10: {
                while (iter.hasNext()) {
                    Triple t = (Triple)iter.next();
                    Node p = t.getPredicate();
                    String u = p.getURI();
                    if (!membershipPattern.matcher(u).matches()) continue;
                    ++count;
                    if (!stopEarly) {
                        continue;
                    }
                    break block10;
                }
                return count;
            }
            int n = count;
            return n;
        }
        finally {
            iter.close();
        }
    }

    public static boolean isContainer(Graph graph, Node container2, Node containerType) {
        if (containerType == null) {
            return GraphContainerUtils.isContainer(graph, container2, BAG) || GraphContainerUtils.isContainer(graph, container2, ALT) || GraphContainerUtils.isContainer(graph, container2, SEQ);
        }
        return graph.contains(container2, RDFtype, containerType);
    }

    private static int getIndex(Triple triple) {
        String u = triple.getPredicate().getURI();
        Matcher m = membershipPattern.matcher(u);
        if (!m.find()) {
            return -9999;
        }
        String index = m.group(1);
        return Integer.parseInt(index);
    }

    private static class ContainerOrder
    implements Comparator<Integer> {
        private ContainerOrder() {
        }

        @Override
        public int compare(Integer i1, Integer i2) {
            int index2;
            int index1 = i1;
            if (index1 < (index2 = i2.intValue())) {
                return -1;
            }
            if (index1 > index2) {
                return 1;
            }
            return 0;
        }
    }
}

